/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.dialog;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

@MixedCopyright(author="Martin", license=License.LGPL3, note="Based on lanterna's FileDialog")
public class DirectoryDialog
extends DialogWindow {
    private final ActionListBox dirListBox;
    private final TextBox dirBox;
    private final Button okButton;
    private final Button cancelButton;
    private final boolean showHiddenDirs;
    private File directory;
    private File selectedDir = null;

    public DirectoryDialog(String title, String description, String actionLabel, TerminalSize dialogSize, boolean showHiddenDirs, File selectedObject) {
        super(title);
        this.showHiddenDirs = showHiddenDirs;
        if (selectedObject == null || !selectedObject.exists()) {
            selectedObject = new File("").getAbsoluteFile();
        }
        selectedObject = selectedObject.getAbsoluteFile();
        Panel contentPane = new Panel();
        contentPane.setLayoutManager((LayoutManager)new BorderLayout());
        Panel dirsPane = new Panel();
        dirsPane.setLayoutManager((LayoutManager)new BorderLayout());
        contentPane.addComponent((Component)dirsPane, (LayoutData)BorderLayout.Location.CENTER);
        if (description != null) {
            contentPane.addComponent((Component)new Label(description), (LayoutData)BorderLayout.Location.TOP);
        }
        int unitHeight = dialogSize.getRows();
        this.dirListBox = new ActionListBox(new TerminalSize(dialogSize.getColumns(), unitHeight));
        dirsPane.addComponent((Component)this.dirListBox.withBorder(Borders.singleLine()), (LayoutData)BorderLayout.Location.CENTER);
        this.dirBox = new TextBox(new TerminalSize(dialogSize.getColumns(), 1));
        dirsPane.addComponent((Component)this.dirBox.withBorder(Borders.singleLine()), (LayoutData)BorderLayout.Location.BOTTOM);
        Panel panelButtons = new Panel((LayoutManager)new GridLayout(2));
        panelButtons.setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.END, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)false, (boolean)false, (int)2, (int)1));
        this.okButton = new Button(actionLabel, (Runnable)new OkHandler());
        panelButtons.addComponent((Component)this.okButton);
        this.cancelButton = new Button(LocalizedString.Cancel.toString(), (Runnable)new CancelHandler());
        panelButtons.addComponent((Component)this.cancelButton);
        contentPane.addComponent((Component)panelButtons, (LayoutData)BorderLayout.Location.BOTTOM);
        if (selectedObject.isFile()) {
            this.directory = selectedObject.getParentFile();
        } else if (selectedObject.isDirectory()) {
            this.directory = selectedObject;
        }
        this.reloadViews(this.directory);
        this.setComponent((Component)contentPane);
    }

    public File showDialog(WindowBasedTextGUI textGUI) {
        this.selectedDir = null;
        super.showDialog(textGUI);
        return this.selectedDir;
    }

    private void reloadViews(final File directory) {
        this.dirBox.setText(directory.getAbsolutePath());
        this.dirListBox.clearItems();
        File[] entries = directory.listFiles();
        if (entries == null) {
            return;
        }
        Arrays.sort(entries, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        if (directory.getAbsoluteFile().getParentFile() != null) {
            this.dirListBox.addItem("..", new Runnable(){

                @Override
                public void run() {
                    DirectoryDialog.this.directory = directory.getAbsoluteFile().getParentFile();
                    DirectoryDialog.this.reloadViews(directory.getAbsoluteFile().getParentFile());
                }
            });
        } else {
            File[] roots;
            File[] fileArray = roots = File.listRoots();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                final File entry = fileArray[i];
                if (!entry.canRead()) continue;
                this.dirListBox.addItem('[' + entry.getPath() + ']', new Runnable(){

                    @Override
                    public void run() {
                        DirectoryDialog.this.directory = entry;
                        DirectoryDialog.this.reloadViews(entry);
                    }
                });
            }
        }
        for (final File entry : entries) {
            if (entry.isHidden() && !this.showHiddenDirs || !entry.isDirectory()) continue;
            this.dirListBox.addItem(entry.getName(), new Runnable(){

                @Override
                public void run() {
                    DirectoryDialog.this.directory = entry;
                    DirectoryDialog.this.reloadViews(entry);
                }
            });
        }
        if (this.dirListBox.isEmpty()) {
            this.dirListBox.addItem("<empty>", (Runnable)new DoNothing());
        }
    }

    private class DoNothing
    implements Runnable {
        private DoNothing() {
        }

        @Override
        public void run() {
        }
    }

    private class CancelHandler
    implements Runnable {
        private CancelHandler() {
        }

        @Override
        public void run() {
            DirectoryDialog.this.selectedDir = null;
            DirectoryDialog.this.close();
        }
    }

    private class OkHandler
    implements Runnable {
        private OkHandler() {
        }

        @Override
        public void run() {
            File dir = new File(DirectoryDialog.this.dirBox.getText());
            if (dir.exists() && dir.isDirectory()) {
                DirectoryDialog.this.selectedDir = dir;
                DirectoryDialog.this.close();
            } else {
                MessageDialog.showMessageDialog((WindowBasedTextGUI)DirectoryDialog.this.getTextGUI(), (String)"Error", (String)"Please select a valid directory name", (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.OK});
            }
        }
    }
}

