/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu;

import adams.core.logging.LoggingHelper;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.core.MenuItem;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import java.io.Serializable;

public abstract class AbstractMenuItemDefinition
implements Serializable,
Comparable<AbstractMenuItemDefinition>,
MenuItem {
    public static final String CATEGORY_PROGRAM = "Program";
    public static final String CATEGORY_TOOLS = "Tools";
    public static final String CATEGORY_MAINTENANCE = "Maintenance";
    public static final String CATEGORY_HELP = "Help";
    private static final long serialVersionUID = -6292351973681147424L;
    protected AbstractTerminalApplication m_Owner;

    public AbstractMenuItemDefinition() {
        this(null);
    }

    public AbstractMenuItemDefinition(AbstractTerminalApplication owner) {
        this.m_Owner = owner;
        this.initialize();
    }

    protected void initialize() {
    }

    public void setOwner(AbstractTerminalApplication value) {
        this.m_Owner = value;
    }

    public AbstractTerminalApplication getOwner() {
        return this.m_Owner;
    }

    public void logMessage(String msg) {
        if (this.m_Owner != null) {
            this.m_Owner.logMessage(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void logError(String msg) {
        if (this.m_Owner != null) {
            this.m_Owner.logError(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void logError(String msg, Throwable t) {
        if (this.m_Owner != null) {
            this.m_Owner.logError(msg, t);
        } else {
            System.err.println(msg + "\n" + LoggingHelper.throwableToString((Throwable)t));
        }
    }

    public abstract String getCategory();

    @Override
    public abstract String getTitle();

    protected void preRun(WindowBasedTextGUI context) {
    }

    protected abstract void doRun(WindowBasedTextGUI var1);

    protected void postRun(WindowBasedTextGUI context) {
    }

    @Override
    public Runnable getRunnable(WindowBasedTextGUI context) {
        return () -> {
            this.preRun(context);
            this.doRun(context);
            this.postRun(context);
        };
    }

    @Override
    public int compareTo(AbstractMenuItemDefinition o) {
        int result = this.getCategory().compareTo(o.getCategory());
        if (result == 0) {
            result = this.getTitle().compareTo(o.getTitle());
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractMenuItemDefinition && this.compareTo((AbstractMenuItemDefinition)obj) == 0;
    }
}

