/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.NestedConsumer;
import adams.terminal.dialog.ComponentDialog;
import adams.terminal.menu.AbstractMenuItemDefinition;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.FileDialog;
import com.googlecode.lanterna.gui2.dialogs.FileDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class FlowEditor
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 4850496199819749023L;

    @Override
    public String getTitle() {
        return "Flow editor";
    }

    protected boolean isValid(String flow) {
        boolean result;
        try {
            NestedConsumer consumer = new NestedConsumer();
            consumer.setQuiet(true);
            consumer.fromString(flow);
            consumer.cleanUp();
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    protected void doRun(WindowBasedTextGUI context) {
        FileDialogBuilder builder = new FileDialogBuilder();
        builder.setTitle("Open");
        builder.setDescription("Select a flow");
        builder.setActionLabel("Open");
        FileDialog dialog = (FileDialog)builder.build();
        File file = dialog.showDialog(context);
        if (file == null) {
            return;
        }
        List lines = FileUtils.loadFromFile((File)(file = new PlaceholderFile(file)));
        if (lines == null) {
            MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)"Error loading flow", (String)("Failed to load flow:\n" + file), (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.OK});
            return;
        }
        TextBox textBox = new TextBox(Utils.flatten((List)lines, (String)"\n"));
        MessageDialogButton retVal = ComponentDialog.showDialog(context, "Flow editor", "Flow:\n" + file, (Component)textBox, Arrays.asList(Window.Hint.CENTERED, Window.Hint.FIT_TERMINAL_WINDOW));
        if (retVal == MessageDialogButton.OK) {
            String flow = textBox.getText();
            if (!this.isValid(flow)) {
                MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)"Invalid flow", (String)"Cannot save flow, invalid!", (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.OK});
                return;
            }
            retVal = MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)"Save flow?", (String)("Save flow?\n" + file), (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.Yes, MessageDialogButton.No});
            if (retVal == MessageDialogButton.Yes && !FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)flow, (boolean)false)) {
                MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)"Error saving flow", (String)("Failed to save flow to:\n" + file), (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.OK});
                return;
            }
        }
    }

    @Override
    public String getCategory() {
        return "Tools";
    }
}

