/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu.remotecommand;

import adams.core.base.BaseHostname;
import adams.core.logging.LoggingHelper;
import adams.core.logging.RemoteReceiveHandler;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.command.basic.StartRemoteLogging;
import adams.scripting.command.basic.StopRemoteLogging;
import adams.scripting.responsehandler.ResponseHandler;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.core.LogTextBox;
import adams.terminal.menu.remotecommand.AbstractRemoteCommandActionResponseHandler;
import adams.terminal.menu.remotecommand.AbstractRemoteCommandActionWithGUI;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public class RemoteLogging
extends AbstractRemoteCommandActionWithGUI {
    public static final int DEFAULT_PORT = 31345;
    protected TextBox m_TextRemote;
    protected TextBox m_TextMaxFailures;
    protected TextBox m_TextLocal;
    protected LogTextBox m_TextLog;
    protected Button m_ButtonStart;
    protected Button m_ButtonStop;
    protected RemoteListenerRunnableWithLog m_Runnable;

    public RemoteLogging() {
    }

    public RemoteLogging(AbstractTerminalApplication owner) {
        super(owner);
    }

    @Override
    public String getTitle() {
        return "Remote logging";
    }

    @Override
    protected LogTextBox getLogTextBox() {
        return this.m_TextLog;
    }

    @Override
    public void logMessage(String msg) {
        this.m_TextLog.addLine(msg);
    }

    @Override
    public void logError(String msg) {
        this.m_TextLog.addLine(msg);
    }

    @Override
    public void logError(String msg, Throwable t) {
        this.m_TextLog.addLine(msg + "\n" + LoggingHelper.throwableToString((Throwable)t));
    }

    protected void startListening() {
        this.m_Runnable = new RemoteListenerRunnableWithLog(new BaseHostname(this.m_TextLocal.getText()).portValue(), 10000, this);
        new Thread((Runnable)((Object)this.m_Runnable)).start();
        StartRemoteLogging start = new StartRemoteLogging();
        start.setInstallListener(false);
        start.setMaxFailures(Integer.parseInt(this.m_TextMaxFailures.getText()));
        start.setLoggingHost(new BaseHostname(this.m_TextLocal.getText()));
        this.m_TextLog.takeFocus();
        this.updateButtons();
        this.sendCommandWithReponse((RemoteCommandWithResponse)start, this.m_CommandProcessor, (ResponseHandler)new LoggingResponseHandler(this), new BaseHostname(this.m_TextLocal.getText()), new BaseHostname(this.m_TextRemote.getText()), 31345);
    }

    protected void stopListening() {
        StopRemoteLogging stop = new StopRemoteLogging();
        stop.setLoggingHost(new BaseHostname(this.m_TextLocal.getText()));
        this.m_Runnable.stopExecution();
        this.m_Runnable = null;
        this.m_TextLog.takeFocus();
        this.updateButtons();
        this.sendCommandWithReponse((RemoteCommandWithResponse)stop, this.m_CommandProcessor, (ResponseHandler)new LoggingResponseHandler(this), new BaseHostname(this.m_TextLocal.getText()), new BaseHostname(this.m_TextRemote.getText()), 31345);
    }

    public void updateButtons() {
        this.m_ButtonStart.setEnabled(this.m_Runnable == null);
        this.m_ButtonStop.setEnabled(this.m_Runnable != null && this.m_Runnable.isRunning());
    }

    public void append(String msg) {
        this.m_TextLog.addLine(msg);
    }

    public void stopListenerRunnable() {
        if (this.m_Runnable != null) {
            this.m_Runnable.stopExecution();
        }
    }

    @Override
    protected Panel createPanel() {
        Panel result = new Panel((LayoutManager)new BorderLayout());
        Panel panel = new Panel((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
        result.addComponent((Component)panel, (LayoutData)BorderLayout.Location.TOP);
        this.m_TextRemote = new TextBox(new TerminalSize(15, 1), "127.0.0.1:12345");
        panel.addComponent((Component)new Label("Remote"));
        panel.addComponent((Component)this.m_TextRemote);
        this.m_TextMaxFailures = new TextBox(new TerminalSize(3, 1), "5");
        this.m_TextMaxFailures.setValidationPattern(Pattern.compile("(-)?[0-9]+"));
        panel.addComponent((Component)new Label("Max failures"));
        panel.addComponent((Component)this.m_TextMaxFailures);
        this.m_TextLocal = new TextBox(new TerminalSize(15, 1), "127.0.0.1:31345");
        panel.addComponent((Component)new Label("Local"));
        panel.addComponent((Component)this.m_TextLocal);
        this.m_ButtonStart = new Button("Go", () -> this.startListening());
        panel.addComponent((Component)this.m_ButtonStart);
        this.m_ButtonStop = new Button("X", () -> this.stopListening());
        panel.addComponent((Component)this.m_ButtonStop);
        this.m_TextLog = new LogTextBox("", TextBox.Style.MULTI_LINE);
        result.addComponent((Component)this.m_TextLog.withBorder(Borders.singleLine((String)"Log")), (LayoutData)BorderLayout.Location.CENTER);
        return result;
    }

    public static class LoggingResponseHandler
    extends AbstractRemoteCommandActionResponseHandler<RemoteLogging> {
        private static final long serialVersionUID = -3200878133646726226L;

        public LoggingResponseHandler(RemoteLogging window) {
            super(window);
        }

        public void responseSuccessful(RemoteCommand cmd) {
            ((RemoteLogging)this.getCommand()).updateButtons();
        }

        public void responseFailed(RemoteCommand cmd, String msg) {
            if (cmd instanceof StartRemoteLogging) {
                ((RemoteLogging)this.getCommand()).stopListenerRunnable();
            }
            System.err.println(msg + "\n" + cmd);
        }
    }

    public static class RemoteListenerRunnableWithLog
    extends RemoteReceiveHandler.AbstractRemoteListenerRunnable {
        private static final long serialVersionUID = -1375651567275850732L;
        protected RemoteLogging m_Command;

        protected RemoteListenerRunnableWithLog(int port, int timeout, RemoteLogging command) {
            super(port, timeout);
            this.m_Command = command;
        }

        protected void postRun() {
            super.postRun();
            this.m_Command.updateButtons();
        }

        protected void publish(LogRecord record) {
            if (record != null) {
                this.m_Command.append(LoggingHelper.assembleMessage((LogRecord)record).toString());
            }
        }
    }
}

