/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu.remotecommand;

import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.scripting.ScriptingHelper;
import adams.scripting.engine.RemoteScriptingEngine;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.dialog.ComponentDialog;
import adams.terminal.menu.remotecommand.AbstractRemoteCommandActionWithGUI;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.util.Arrays;

public class StartListening
extends AbstractRemoteCommandActionWithGUI {
    protected TextBox m_Engine;

    public StartListening() {
    }

    public StartListening(AbstractTerminalApplication owner) {
        super(owner);
    }

    @Override
    public String getTitle() {
        return "Start listening...";
    }

    @Override
    protected Panel createPanel() {
        Panel result = new Panel();
        result.setLayoutManager((LayoutManager)new BorderLayout());
        result.addComponent((Component)new Label("Engine"), (LayoutData)BorderLayout.Location.TOP);
        this.m_Engine = new TextBox(new TerminalSize(20, 3));
        this.m_Engine.setText(ScriptingHelper.getSingleton().getDefaultEngine().toCommandLine());
        result.addComponent((Component)this.m_Engine, (LayoutData)BorderLayout.Location.CENTER);
        return result;
    }

    @Override
    protected void doRun(WindowBasedTextGUI context) {
        ComponentDialog dialog = new ComponentDialog("Start listening", null, (Component)this.createPanel());
        dialog.setSize(context, 0.75, 0.5);
        dialog.setHints(Arrays.asList(Window.Hint.FIXED_SIZE, Window.Hint.CENTERED));
        MessageDialogButton retVal = dialog.showDialog(context);
        if (retVal != MessageDialogButton.OK) {
            return;
        }
        try {
            this.getOwner().setRemoteScriptingEngine((RemoteScriptingEngine)OptionUtils.forAnyCommandLine(RemoteScriptingEngine.class, (String)this.m_Engine.getText()));
        }
        catch (Exception e) {
            MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)"Error", (String)("Failed to start listening!\n" + LoggingHelper.throwableToString((Throwable)e)), (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.OK});
        }
    }
}

