/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.responsehandler;

import adams.core.io.ConsoleHelper;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithErrorMessage;
import adams.scripting.responsehandler.AbstractResponseHandler;
import adams.terminal.core.LogTextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;

public class LogTextBoxResponseHandler
extends AbstractResponseHandler {
    private static final long serialVersionUID = -6193490944184585319L;
    protected LogTextBox m_Log;

    public String globalInfo() {
        return "Logs responses.";
    }

    public void setLog(LogTextBox value) {
        this.m_Log = value;
    }

    public LogTextBox getLog() {
        return this.m_Log;
    }

    protected void displayErrorMessage(RemoteCommandWithErrorMessage cmd) {
        if (this.m_Log != null && this.m_Log.getTextGUI() instanceof WindowBasedTextGUI) {
            MessageDialog.showMessageDialog((WindowBasedTextGUI)((WindowBasedTextGUI)this.m_Log.getTextGUI()), (String)cmd.getClass().getName(), (String)cmd.getErrorMessage(), (MessageDialogButton[])new MessageDialogButton[0]);
        } else {
            ConsoleHelper.printlnErr((String)(cmd.getClass().getName() + "\n" + cmd.getErrorMessage()));
        }
    }

    public void responseSuccessful(RemoteCommand cmd) {
        if (!this.m_Enabled) {
            return;
        }
        if (this.m_Log != null) {
            this.m_Log.append(LoggingLevel.INFO, "Successful response: " + OptionUtils.getCommandLine((Object)cmd) + "\n" + cmd);
        }
        if (cmd instanceof RemoteCommandWithErrorMessage && ((RemoteCommandWithErrorMessage)cmd).hasErrorMessage()) {
            this.displayErrorMessage((RemoteCommandWithErrorMessage)cmd);
        }
    }

    public void responseFailed(RemoteCommand cmd, String msg) {
        if (!this.m_Enabled) {
            return;
        }
        if (this.m_Log != null) {
            this.m_Log.append(LoggingLevel.SEVERE, "Failed response: " + OptionUtils.getCommandLine((Object)cmd) + "\nMessage: " + msg + "\n" + cmd);
        }
        if (cmd instanceof RemoteCommandWithErrorMessage && ((RemoteCommandWithErrorMessage)cmd).hasErrorMessage()) {
            this.displayErrorMessage((RemoteCommandWithErrorMessage)cmd);
        }
    }
}

