/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.core;

import adams.terminal.core.MenuItem;
import adams.terminal.core.MenuListDialog;
import adams.terminal.core.MenuListDialogBuilder;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import java.util.Arrays;

public class Menu
extends Button {
    protected MenuListDialogBuilder builder;
    protected WindowBasedTextGUI context;

    public Menu(String label, WindowBasedTextGUI context) {
        super(label);
        this.context = context;
        this.builder = new MenuListDialogBuilder();
        this.builder.setTitle("");
        this.addListener(this.newListener());
    }

    protected Button.Listener newListener() {
        return button -> {
            MenuListDialog dialog = (MenuListDialog)this.builder.build();
            dialog.setHints(Arrays.asList(Window.Hint.FIXED_POSITION));
            dialog.setPosition(new TerminalPosition(this.getPosition().getColumn() + 2, this.getPosition().getRow() + 3));
            dialog.showDialog(this.context);
        };
    }

    public void addMenuItem(String label, Runnable action) {
        this.builder.addAction(label, action);
    }

    public void addMenuItem(MenuItem item) {
        this.builder.addAction(item.getTitle(), item.getRunnable(this.context));
    }
}

