/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu;

import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.terminal.menu.AbstractMenuItemDefinition;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.FileDialog;
import com.googlecode.lanterna.gui2.dialogs.FileDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.io.File;

public class FlowRunner
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 4850496199819749023L;

    @Override
    public String getTitle() {
        return "Flow runner";
    }

    @Override
    protected void doRun(WindowBasedTextGUI context) {
        FileDialogBuilder builder = new FileDialogBuilder();
        builder.setTitle("Open");
        builder.setDescription("Select a flow");
        builder.setActionLabel("Open");
        FileDialog dialog = (FileDialog)builder.build();
        File file = dialog.showDialog(context);
        if (file == null) {
            return;
        }
        Actor flow = ActorUtils.read((String)file.getAbsolutePath());
        if (!(flow instanceof Flow)) {
            MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)this.getTitle(), (String)("Root actor is not a " + Flow.class.getName() + ", cannot execute!"), (MessageDialogButton[])new MessageDialogButton[0]);
            return;
        }
        MessageDialogButton retVal = MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)this.getTitle(), (String)"Execute flow?", (MessageDialogButton[])new MessageDialogButton[]{MessageDialogButton.Yes, MessageDialogButton.No});
        if (retVal == null || retVal == MessageDialogButton.No) {
            return;
        }
        ((Flow)flow).setHeadless(true);
        String msg = flow.setUp();
        if (msg != null) {
            MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)this.getTitle(), (String)("Failed to setup flow:\n" + msg), (MessageDialogButton[])new MessageDialogButton[0]);
            flow.cleanUp();
            return;
        }
        msg = flow.execute();
        if (msg != null) {
            MessageDialog.showMessageDialog((WindowBasedTextGUI)context, (String)this.getTitle(), (String)("Failed to execute flow:\n" + msg), (MessageDialogButton[])new MessageDialogButton[0]);
            flow.cleanUp();
            return;
        }
        flow.cleanUp();
    }

    @Override
    public String getCategory() {
        return "Tools";
    }
}

