/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu;

import adams.core.ClassLister;
import adams.terminal.menu.AbstractMenuItemDefinition;
import adams.terminal.menu.remotecommand.AbstractRemoteCommandAction;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.ActionListDialog;
import com.googlecode.lanterna.gui2.dialogs.ActionListDialogBuilder;
import java.util.ArrayList;
import java.util.Collections;

public class RemoteCommands
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 4850496199819749023L;

    @Override
    public String getTitle() {
        return "Remote commands";
    }

    @Override
    protected void doRun(WindowBasedTextGUI context) {
        ActionListDialogBuilder builder = new ActionListDialogBuilder();
        builder.setTitle("Remote commands");
        Class[] classes = ClassLister.getSingleton().getClasses(AbstractRemoteCommandAction.class);
        ArrayList<AbstractRemoteCommandAction> actions = new ArrayList<AbstractRemoteCommandAction>();
        for (Class cls : classes) {
            try {
                AbstractRemoteCommandAction action = (AbstractRemoteCommandAction)cls.newInstance();
                action.setOwner(this.getOwner());
                actions.add(action);
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate remote command action: " + cls.getName());
                e.printStackTrace();
            }
        }
        Collections.sort(actions);
        for (AbstractRemoteCommandAction act : actions) {
            builder.addAction(act.getTitle(), act.getRunnable(context));
        }
        ((ActionListDialog)builder.build()).showDialog(context);
    }

    @Override
    public String getCategory() {
        return "Program";
    }
}

