/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu;

import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.dialog.ComponentDialog;
import adams.terminal.menu.AbstractMenuItemDefinition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class SystemInfo
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = -6548349613973153076L;

    public SystemInfo() {
        this(null);
    }

    public SystemInfo(AbstractTerminalApplication owner) {
        super(owner);
    }

    @Override
    protected void doRun(WindowBasedTextGUI context) {
        adams.core.SystemInfo info = new adams.core.SystemInfo();
        ArrayList sorted = new ArrayList(info.getInfo().keySet());
        Collections.sort(sorted);
        ActionListBox keys = new ActionListBox();
        keys.setPreferredSize(new TerminalSize(40, 10));
        TextBox value = new TextBox(new TerminalSize(40, 5));
        value.setCaretWarp(true);
        value.setReadOnly(true);
        for (String key : sorted) {
            keys.addItem(key, () -> {
                value.setText((String)info.getInfo().get(key));
                value.setCaretPosition(0, 0);
            });
        }
        Panel panel = new Panel((LayoutManager)new BorderLayout());
        panel.addComponent((Component)keys.withBorder(Borders.singleLine((String)"Property")), (LayoutData)BorderLayout.Location.CENTER);
        panel.addComponent((Component)value.withBorder(Borders.singleLine((String)"Value")), (LayoutData)BorderLayout.Location.BOTTOM);
        panel.setPreferredSize(new TerminalSize(40, 15));
        ComponentDialog.showDialog(context, "System info", null, (Component)panel, Arrays.asList(Window.Hint.CENTERED), false, false, true);
    }

    @Override
    public String getTitle() {
        return "System info";
    }

    @Override
    public String getCategory() {
        return "Help";
    }
}

