/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu.remotecommand;

import adams.core.base.BaseHostname;
import adams.core.net.PortManager;
import adams.scripting.ScriptingHelper;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.command.basic.StopEngine;
import adams.scripting.connection.Connection;
import adams.scripting.connection.DefaultConnection;
import adams.scripting.engine.DefaultScriptingEngine;
import adams.scripting.processor.RemoteCommandProcessor;
import adams.scripting.processor.RemoteCommandProcessorHandler;
import adams.scripting.requesthandler.LogTextBoxRequestHandler;
import adams.scripting.requesthandler.LoggingHandler;
import adams.scripting.requesthandler.RequestHandler;
import adams.scripting.responsehandler.LogTextBoxResponseHandler;
import adams.scripting.responsehandler.MultiHandler;
import adams.scripting.responsehandler.ResponseHandler;
import adams.terminal.application.AbstractLanternaTerminalApplication;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.core.LogTextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;

public abstract class AbstractRemoteCommandAction
implements Comparable<AbstractRemoteCommandAction>,
RemoteCommandProcessorHandler {
    protected AbstractTerminalApplication m_Owner;
    protected RemoteCommandProcessor m_CommandProcessor;

    public AbstractRemoteCommandAction() {
        this(null);
    }

    public AbstractRemoteCommandAction(AbstractTerminalApplication owner) {
        this.m_Owner = owner;
        this.initialize();
    }

    protected void initialize() {
        this.m_CommandProcessor = ScriptingHelper.getSingleton().getDefaultProcessor();
    }

    public void setOwner(AbstractTerminalApplication value) {
        this.m_Owner = value;
    }

    public AbstractTerminalApplication getOwner() {
        return this.m_Owner;
    }

    public void setCommandProcessor(RemoteCommandProcessor value) {
        this.m_CommandProcessor = value;
    }

    public RemoteCommandProcessor getCommandProcessor() {
        return this.m_CommandProcessor;
    }

    public abstract String getTitle();

    protected LogTextBox getLogTextBox() {
        if (this.m_Owner instanceof AbstractLanternaTerminalApplication) {
            return ((AbstractLanternaTerminalApplication)this.m_Owner).getLogTextBox();
        }
        return null;
    }

    public void logMessage(String msg) {
        this.m_Owner.logMessage(msg);
    }

    public void logError(String msg) {
        this.m_Owner.logError(msg);
    }

    public void logError(String msg, Throwable t) {
        this.m_Owner.logError(msg, t);
    }

    protected DefaultScriptingEngine configureEngine(ResponseHandler responseHandler, int defPort) {
        DefaultScriptingEngine result = new DefaultScriptingEngine();
        result.setPort(PortManager.getSingleton().next(result.getClass(), defPort).intValue());
        LogTextBoxRequestHandler simpleRequest = new LogTextBoxRequestHandler();
        simpleRequest.setLog(this.getLogTextBox());
        adams.scripting.requesthandler.MultiHandler multiRequest = new adams.scripting.requesthandler.MultiHandler();
        multiRequest.setHandlers(new RequestHandler[]{new LoggingHandler(), simpleRequest});
        result.setRequestHandler((RequestHandler)multiRequest);
        LogTextBoxResponseHandler simpleResponse = new LogTextBoxResponseHandler();
        simpleResponse.setLog(this.getLogTextBox());
        MultiHandler multiResponse = new MultiHandler();
        multiResponse.setHandlers(new ResponseHandler[]{new adams.scripting.responsehandler.LoggingHandler(), simpleResponse});
        if (responseHandler != null) {
            multiResponse.addHandler(responseHandler);
        }
        result.setResponseHandler((ResponseHandler)multiResponse);
        return result;
    }

    public void sendCommand(RemoteCommand cmd, RemoteCommandProcessor processor, BaseHostname remote) {
        DefaultConnection conn = new DefaultConnection();
        conn.setHost(remote.hostnameValue());
        conn.setPort(remote.portValue());
        String msg = conn.sendRequest(cmd, processor);
        if (msg != null) {
            this.logError("Failed to send command '" + cmd.toCommandLine() + "':\n" + msg);
        }
    }

    public void sendCommandWithReponse(RemoteCommandWithResponse cmd, RemoteCommandProcessor processor, ResponseHandler responseHandler, BaseHostname local, BaseHostname remote, int defPort) {
        DefaultScriptingEngine engine = this.configureEngine(responseHandler, defPort);
        new Thread(() -> engine.execute()).start();
        DefaultConnection connResp = new DefaultConnection();
        connResp.setHost(local.hostnameValue());
        connResp.setPort(engine.getPort());
        cmd.setResponseConnection((Connection)connResp);
        DefaultConnection conn = new DefaultConnection();
        conn.setHost(remote.hostnameValue());
        conn.setPort(remote.portValue());
        String msg = conn.sendRequest((RemoteCommand)cmd, processor);
        if (msg != null) {
            engine.stopExecution();
            this.logError("Failed to send command '" + cmd.toCommandLine() + "':\n" + msg);
        } else {
            StopEngine stop = new StopEngine();
            stop.setType(StopEngine.EngineType.RESPONSE);
            stop.setResponseConnection((Connection)connResp);
            conn.sendRequest((RemoteCommand)stop, processor);
        }
    }

    protected void preRun(WindowBasedTextGUI context) {
    }

    protected abstract void doRun(WindowBasedTextGUI var1);

    protected void postRun(WindowBasedTextGUI context) {
    }

    public Runnable getRunnable(WindowBasedTextGUI context) {
        return () -> {
            this.preRun(context);
            this.doRun(context);
            this.postRun(context);
        };
    }

    @Override
    public int compareTo(AbstractRemoteCommandAction o) {
        return this.getTitle().compareTo(o.getTitle());
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractRemoteCommandAction && this.compareTo((AbstractRemoteCommandAction)obj) == 0;
    }
}

