/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu.remotecommand;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.base.BaseHostname;
import adams.core.option.OptionUtils;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandOnFlow;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.command.basic.StopEngine;
import adams.scripting.command.flow.GetFlow;
import adams.scripting.connection.Connection;
import adams.scripting.connection.DefaultConnection;
import adams.scripting.engine.DefaultScriptingEngine;
import adams.scripting.responsehandler.LogTextBoxResponseHandler;
import adams.scripting.responsehandler.ResponseHandler;
import adams.terminal.core.LogTextBox;
import adams.terminal.menu.remotecommand.AbstractRemoteFlowCommandAction;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;

public class RemoteFlowCommands
extends AbstractRemoteFlowCommandAction {
    protected TextBox m_GOECommand;
    protected Button m_ButtonExecute;
    protected LogTextBox m_Log;
    protected LogTextBoxResponseHandler m_ResponseLogger;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ResponseLogger = new LogTextBoxResponseHandler();
    }

    @Override
    public String getTitle() {
        return "Remote flows";
    }

    @Override
    protected Panel createPanel() {
        Panel result = super.createPanel();
        Panel panelAll = new Panel((LayoutManager)new BorderLayout());
        this.m_PanelBottom.addComponent((Component)panelAll);
        Panel panelCmd = new Panel((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
        panelAll.addComponent((Component)panelCmd, (LayoutData)BorderLayout.Location.TOP);
        this.m_GOECommand = new TextBox(new TerminalSize(40, 1), new GetFlow().toCommandLine());
        panelCmd.addComponent((Component)new Label("Command"));
        panelCmd.addComponent((Component)this.m_GOECommand);
        this.m_ButtonExecute = new Button("Run");
        this.m_ButtonExecute.addListener(button -> this.executeCommand());
        Panel panelButton = new Panel((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
        panelButton.addComponent((Component)this.m_ButtonExecute);
        panelCmd.addComponent((Component)panelButton);
        this.m_Log = new LogTextBox(new TerminalSize(40, 10));
        panelAll.addComponent((Component)this.m_Log.withBorder(Borders.singleLine((String)"Log")), (LayoutData)BorderLayout.Location.CENTER);
        this.m_ResponseLogger.setLog(this.m_Log);
        return result;
    }

    protected void executeCommand() {
        BaseHostname local = new BaseHostname(this.m_TextLocal.getText());
        BaseHostname remote = new BaseHostname(this.m_TextRemote.getText());
        DefaultScriptingEngine engine = this.configureEngine((ResponseHandler)this.m_ResponseLogger);
        new Thread(() -> engine.execute()).start();
        int[] ids = this.getSelectedFlowIDs();
        DefaultConnection conn = new DefaultConnection();
        conn.setHost(remote.hostnameValue());
        conn.setPort(remote.portValue());
        MessageCollection errors = new MessageCollection();
        DefaultConnection connResp = new DefaultConnection();
        connResp.setPort(local.portValue());
        for (int id : ids) {
            String msg;
            RemoteCommandOnFlow cmd;
            try {
                cmd = (RemoteCommandOnFlow)OptionUtils.forCommandLine(RemoteCommandOnFlow.class, (String)this.m_GOECommand.getText());
            }
            catch (Exception e) {
                errors.add("Failed to instantiate command: " + this.m_GOECommand.getText(), (Throwable)e);
                continue;
            }
            cmd.setID(id);
            if (cmd instanceof RemoteCommandWithResponse) {
                ((RemoteCommandWithResponse)cmd).setResponseConnection((Connection)connResp);
            }
            if ((msg = conn.sendRequest((RemoteCommand)cmd, this.m_CommandProcessor)) == null) continue;
            errors.add(msg);
        }
        StopEngine stop = new StopEngine();
        stop.setType(StopEngine.EngineType.RESPONSE);
        stop.setResponseConnection((Connection)connResp);
        conn.sendRequest((RemoteCommand)stop, this.m_CommandProcessor);
        if (!errors.isEmpty()) {
            this.logError("Failed to execute command for ID(s): " + Utils.arrayToString((Object)ids) + "!\n" + errors);
        }
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        this.m_ButtonExecute.setEnabled(this.getSelectedRows().length > 0);
    }
}

