/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.requesthandler;

import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.scripting.command.RemoteCommand;
import adams.scripting.requesthandler.AbstractRequestHandler;
import adams.terminal.core.LogTextBox;

public class LogTextBoxRequestHandler
extends AbstractRequestHandler {
    private static final long serialVersionUID = -1354303964630420400L;
    protected LogTextBox m_Log;

    public String globalInfo() {
        return "Logs requests.";
    }

    public void setLog(LogTextBox value) {
        this.m_Log = value;
    }

    public LogTextBox getLog() {
        return this.m_Log;
    }

    public void requestSuccessful(RemoteCommand cmd) {
        if (this.m_Enabled && this.m_Log != null) {
            this.m_Log.append(LoggingLevel.INFO, "Successful request: " + OptionUtils.getCommandLine((Object)cmd) + "\n" + cmd);
        }
    }

    public void requestFailed(RemoteCommand cmd, String msg) {
        if (this.m_Enabled && this.m_Log != null) {
            this.m_Log.append(LoggingLevel.SEVERE, "Failed request: " + OptionUtils.getCommandLine((Object)cmd) + "\nMessage: " + msg + "\n" + cmd);
        }
    }

    public void requestRejected(RemoteCommand cmd, String msg) {
        if (this.m_Enabled && this.m_Log != null) {
            this.m_Log.append(LoggingLevel.WARNING, "Rejected request: " + OptionUtils.getCommandLine((Object)cmd) + "\nMessage: " + msg + "\n" + cmd);
        }
    }
}

