/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.application;

import adams.core.ClassLister;
import adams.core.logging.LoggingObject;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.core.Menu;
import adams.terminal.core.MenuBar;
import adams.terminal.menu.AbstractMenuItemDefinition;
import adams.terminal.menu.ProgramExit;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public class ApplicationMenu
extends LoggingObject
implements Serializable {
    private static final long serialVersionUID = 7821913342345552227L;
    protected AbstractTerminalApplication m_Owner;

    public ApplicationMenu(AbstractTerminalApplication owner) {
        this.m_Owner = owner;
    }

    public AbstractTerminalApplication getOwner() {
        return this.m_Owner;
    }

    public MenuBar getMenuBar(WindowBasedTextGUI context) {
        AbstractMenuItemDefinition definition;
        MenuBar result = new MenuBar();
        Class[] classes = ClassLister.getSingleton().getClasses(AbstractMenuItemDefinition.class);
        HashMap menus = new HashMap();
        for (Class cls : classes) {
            try {
                definition = (AbstractMenuItemDefinition)cls.newInstance();
                definition.setOwner(this.getOwner());
                if (!menus.containsKey(definition.getCategory())) {
                    menus.put(definition.getCategory(), new ArrayList());
                }
                ((List)menus.get(definition.getCategory())).add(definition);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to create new instance of: " + cls.getName(), (Throwable)e);
            }
        }
        for (String key : menus.keySet()) {
            Collections.sort((List)menus.get(key));
        }
        Menu menuProgram = new Menu("Program", context);
        for (AbstractMenuItemDefinition def : (List)menus.get("Program")) {
            if (def.getClass() == ProgramExit.class) continue;
            menuProgram.addMenuItem(def);
        }
        definition = new ProgramExit();
        definition.setOwner(this.getOwner());
        menuProgram.addMenuItem(definition);
        result.addMenu(menuProgram);
        ArrayList categories = new ArrayList(menus.keySet());
        categories.remove("Program");
        categories.remove("Help");
        for (String category : categories) {
            Menu menu = new Menu(category, context);
            for (AbstractMenuItemDefinition def : (List)menus.get(category)) {
                menu.addMenuItem(def);
            }
            result.addMenu(menu);
        }
        Menu menuHelp = new Menu("Help", context);
        for (AbstractMenuItemDefinition def : (List)menus.get("Help")) {
            menuHelp.addMenuItem(def);
        }
        result.addMenu(menuHelp);
        return result;
    }
}

