/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.menu.remotecommand;

import adams.core.base.BaseHostname;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.command.basic.Kill;
import adams.scripting.command.basic.Stop;
import adams.scripting.command.flow.ListFlows;
import adams.scripting.command.flow.SendFlowControlCommand;
import adams.scripting.engine.DefaultScriptingEngine;
import adams.scripting.responsehandler.ResponseHandler;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.menu.remotecommand.AbstractRemoteCommandActionResponseHandler;
import adams.terminal.menu.remotecommand.AbstractRemoteCommandActionWithGUI;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.table.Table;
import com.googlecode.lanterna.gui2.table.TableModel;

public abstract class AbstractRemoteFlowCommandAction
extends AbstractRemoteCommandActionWithGUI {
    public static final int DEFAULT_PORT = 21345;
    public static final String NO_DATA = "No data";
    protected Panel m_PanelFlows;
    protected Panel m_PanelBottom;
    protected TextBox m_TextRemote;
    protected TextBox m_TextLocal;
    protected Button m_ButtonRefresh;
    protected Table<String> m_TableFlows;
    protected Button m_ButtonPauseFlow;
    protected Button m_ButtonResumeFlow;
    protected Button m_ButtonStopFlow;
    protected Button m_ButtonStopAdams;
    protected Button m_ButtonKillAdams;

    public AbstractRemoteFlowCommandAction() {
    }

    public AbstractRemoteFlowCommandAction(AbstractTerminalApplication owner) {
        super(owner);
    }

    @Override
    protected Panel createPanel() {
        Panel result = new Panel((LayoutManager)new GridLayout(1));
        this.m_PanelFlows = new Panel((LayoutManager)new BorderLayout());
        result.addComponent((Component)this.m_PanelFlows.withBorder(Borders.singleLine()));
        Panel panelConn = new Panel((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
        this.m_PanelFlows.addComponent((Component)panelConn.withBorder(Borders.singleLine((String)"Connection")), (LayoutData)BorderLayout.Location.TOP);
        this.m_TextRemote = new TextBox(new TerminalSize(15, 1), "127.0.0.1:12345");
        panelConn.addComponent((Component)new Label("Remote"));
        panelConn.addComponent((Component)this.m_TextRemote);
        this.m_TextLocal = new TextBox(new TerminalSize(15, 1), "127.0.0.1:21345");
        panelConn.addComponent((Component)new Label("Local"));
        panelConn.addComponent((Component)this.m_TextLocal);
        this.m_ButtonRefresh = new Button("Refresh", () -> this.refreshFlows());
        panelConn.addComponent((Component)this.m_ButtonRefresh);
        this.m_TableFlows = new Table(new String[]{NO_DATA});
        this.m_PanelFlows.addComponent((Component)this.m_TableFlows.withBorder(Borders.singleLine((String)"Flows")), (LayoutData)BorderLayout.Location.CENTER);
        Panel panelButtons = new Panel((LayoutManager)new GridLayout(1));
        this.m_PanelFlows.addComponent((Component)panelButtons.withBorder(Borders.singleLine((String)"Actions")), (LayoutData)BorderLayout.Location.RIGHT);
        this.m_ButtonPauseFlow = new Button("Pause", () -> this.pauseFlow());
        panelButtons.addComponent((Component)this.m_ButtonPauseFlow);
        this.m_ButtonResumeFlow = new Button("Resume", () -> this.resumeFlow());
        panelButtons.addComponent((Component)this.m_ButtonResumeFlow);
        this.m_ButtonStopFlow = new Button("Stop", () -> this.stopFlow());
        panelButtons.addComponent((Component)this.m_ButtonStopFlow);
        this.m_ButtonStopAdams = new Button("Stop Adams", () -> this.stopAdams());
        panelButtons.addComponent((Component)this.m_ButtonStopAdams);
        this.m_ButtonKillAdams = new Button("Kill Adams", () -> this.killAdams());
        panelButtons.addComponent((Component)this.m_ButtonKillAdams);
        this.m_PanelBottom = new Panel((LayoutManager)new BorderLayout());
        result.addComponent((Component)this.m_PanelBottom.withBorder(Borders.singleLine()));
        return result;
    }

    protected DefaultScriptingEngine configureEngine(ResponseHandler responseHandler) {
        return this.configureEngine(responseHandler, 21345);
    }

    public void sendCommand(RemoteCommand cmd) {
        this.sendCommand(cmd, this.m_CommandProcessor, new BaseHostname(this.m_TextRemote.getText()));
    }

    public void sendCommandWithReponse(RemoteCommandWithResponse cmd) {
        this.sendCommandWithReponse(cmd, null);
    }

    public void sendCommandWithReponse(RemoteCommandWithResponse cmd, ResponseHandler responseHandler) {
        this.sendCommandWithReponse(cmd, this.m_CommandProcessor, responseHandler, new BaseHostname(this.m_TextLocal.getText()), new BaseHostname(this.m_TextRemote.getText()), 21345);
    }

    protected void refreshFlows() {
        this.sendCommandWithReponse((RemoteCommandWithResponse)new ListFlows(), (ResponseHandler)new FlowListResponseHandler(this));
    }

    protected int[] getSelectedRows() {
        int sel = this.m_TableFlows.getSelectedRow();
        if (sel >= this.m_TableFlows.getTableModel().getRowCount()) {
            return new int[0];
        }
        return new int[]{sel};
    }

    protected int[] getSelectedFlowIDs() {
        int[] sel = this.getSelectedRows();
        int[] result = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            result[i] = Integer.parseInt((String)this.m_TableFlows.getTableModel().getRow(i).get(0));
        }
        return result;
    }

    protected void pauseFlow() {
        int[] ids = this.getSelectedFlowIDs();
        int[] sel = this.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            boolean paused = Boolean.parseBoolean((String)this.m_TableFlows.getTableModel().getRow(i).get(1));
            boolean stopped = Boolean.parseBoolean((String)this.m_TableFlows.getTableModel().getRow(i).get(2));
            if (stopped || paused) continue;
            SendFlowControlCommand cmd = new SendFlowControlCommand();
            cmd.setID(ids[i]);
            cmd.setCommand(SendFlowControlCommand.Command.PAUSE);
            this.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
        }
        this.refreshFlows();
    }

    protected void resumeFlow() {
        int[] ids = this.getSelectedFlowIDs();
        int[] sel = this.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            boolean paused = Boolean.parseBoolean((String)this.m_TableFlows.getTableModel().getRow(i).get(1));
            boolean stopped = Boolean.parseBoolean((String)this.m_TableFlows.getTableModel().getRow(i).get(2));
            if (stopped || !paused) continue;
            SendFlowControlCommand cmd = new SendFlowControlCommand();
            cmd.setID(ids[i]);
            cmd.setCommand(SendFlowControlCommand.Command.RESUME);
            this.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
        }
        this.refreshFlows();
    }

    protected void stopFlow() {
        int[] ids = this.getSelectedFlowIDs();
        int[] sel = this.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            boolean stopped = Boolean.parseBoolean((String)this.m_TableFlows.getTableModel().getRow(i).get(2));
            if (stopped) continue;
            SendFlowControlCommand cmd = new SendFlowControlCommand();
            cmd.setID(ids[i]);
            cmd.setCommand(SendFlowControlCommand.Command.STOP);
            this.sendCommandWithReponse((RemoteCommandWithResponse)cmd);
        }
        this.refreshFlows();
    }

    protected void stopAdams() {
        this.sendCommand((RemoteCommand)new Stop());
    }

    protected void killAdams() {
        this.sendCommand((RemoteCommand)new Kill());
    }

    public Table getFlowsTable() {
        return this.m_TableFlows;
    }

    protected void updateButtons() {
        this.m_ButtonPauseFlow.setEnabled(this.getSelectedFlowIDs().length > 0);
        this.m_ButtonResumeFlow.setEnabled(this.getSelectedFlowIDs().length > 0);
        this.m_ButtonStopFlow.setEnabled(this.getSelectedFlowIDs().length > 0);
    }

    public static class FlowListResponseHandler
    extends AbstractRemoteCommandActionResponseHandler<AbstractRemoteFlowCommandAction> {
        private static final long serialVersionUID = 6205405220037007365L;

        public FlowListResponseHandler(AbstractRemoteFlowCommandAction command) {
            super(command);
        }

        public void responseSuccessful(RemoteCommand cmd) {
            ListFlows list;
            if (cmd instanceof ListFlows && (list = (ListFlows)cmd).getResponsePayloadObjects().length > 0) {
                int i;
                SpreadSheet sheet = (SpreadSheet)list.getResponsePayloadObjects()[0];
                Object[] cells = new String[sheet.getColumnCount()];
                for (i = 0; i < sheet.getColumnCount(); ++i) {
                    cells[i] = sheet.getHeaderRow().getContent(i);
                }
                TableModel model = new TableModel((String[])cells);
                for (Row row : sheet.rows()) {
                    cells = new String[sheet.getColumnCount()];
                    for (i = 0; i < sheet.getColumnCount(); ++i) {
                        cells[i] = row.getContent(i);
                    }
                    model.addRow(cells);
                }
                ((AbstractRemoteFlowCommandAction)this.m_Command).getFlowsTable().setTableModel(model);
            }
        }

        public void responseFailed(RemoteCommand cmd, String msg) {
            if (cmd instanceof ListFlows) {
                ((AbstractRemoteFlowCommandAction)this.m_Command).getFlowsTable().setTableModel(new TableModel(new String[]{AbstractRemoteFlowCommandAction.NO_DATA}));
                ((AbstractRemoteFlowCommandAction)this.m_Command).getOwner().logError("Failed to retrieve remote flows:\n" + msg);
            }
        }
    }
}

