/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.dialog;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.ComboBox;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class OptionDialog
extends DialogWindow {
    protected ComboBox<String> comboBox;
    protected String result;

    public OptionDialog(String title, String description, String[] options, String initial) {
        this(title, description, options, initial, new ArrayList<Window.Hint>());
    }

    public OptionDialog(String title, String description, String[] options, String initial, Collection<Window.Hint> hints) {
        super(title);
        this.comboBox = new ComboBox(Arrays.asList(options));
        Panel buttonPanel = new Panel();
        buttonPanel.setLayoutManager((LayoutManager)new GridLayout(2).setHorizontalSpacing(1));
        buttonPanel.addComponent(new Button(LocalizedString.OK.toString(), () -> this.onOK()).setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.CENTER, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false)));
        buttonPanel.addComponent((Component)new Button(LocalizedString.Cancel.toString(), () -> this.onCancel()));
        Panel mainPanel = new Panel();
        mainPanel.setLayoutManager((LayoutManager)new GridLayout(1).setLeftMarginSize(1).setRightMarginSize(1));
        if (description != null) {
            mainPanel.addComponent((Component)new Label(description));
        }
        this.setHints(hints);
        mainPanel.addComponent((Component)new EmptySpace(TerminalSize.ONE));
        ((ComboBox)this.comboBox.setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.FILL, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false))).addTo(mainPanel);
        mainPanel.addComponent((Component)new EmptySpace(TerminalSize.ONE));
        ((Panel)buttonPanel.setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.END, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)false, (boolean)false))).addTo(mainPanel);
        this.setComponent((Component)mainPanel);
    }

    protected void onOK() {
        String text;
        this.result = text = this.comboBox.getText();
        this.close();
    }

    protected void onCancel() {
        this.close();
    }

    public String showDialog(WindowBasedTextGUI textGUI) {
        this.result = null;
        super.showDialog(textGUI);
        return this.result;
    }

    public static String showDialog(WindowBasedTextGUI textGUI, String title, String description, String[] options, String initial) {
        return OptionDialog.showDialog(textGUI, title, description, options, initial, new ArrayList<Window.Hint>());
    }

    public static String showDialog(WindowBasedTextGUI textGUI, String title, String description, String[] options, String initial, Collection<Window.Hint> hints) {
        OptionDialog dialog = new OptionDialog(title, description, options, initial);
        return dialog.showDialog(textGUI);
    }
}

