/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.DateFormatString;
import adams.data.filter.AbstractFilter;
import adams.data.filter.AbstractTimeseriesFilterTestCase;
import adams.data.filter.MultiFilter;
import adams.data.filter.TimeseriesRowNorm;
import adams.data.filter.TimeseriesSAX;
import adams.data.timeseries.Timeseries;
import adams.env.Environment;
import adams.test.TimeseriesTestHelper;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TimeseriesSAXTest
extends AbstractTimeseriesFilterTestCase {
    public TimeseriesSAXTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ((TimeseriesTestHelper)this.m_TestHelper).setRegressionTimestampFormatWrite(new DateFormatString("yyyy-MM-dd HH:mm:ss"));
    }

    public AbstractFilter<Timeseries> getFilter() {
        return new TimeseriesSAX();
    }

    protected String[] getRegressionInputFiles() {
        return new String[]{"wine_mod.sts", "wine_mod.sts", "wine_mod.sts", "wine_mod.sts"};
    }

    protected AbstractFilter[] getRegressionSetups() {
        MultiFilter[] result = new MultiFilter[4];
        TimeseriesRowNorm row = new TimeseriesRowNorm();
        result[0] = new MultiFilter();
        TimeseriesSAX sax = new TimeseriesSAX();
        result[0].setSubFilters(new AbstractFilter[]{row, sax});
        result[1] = new MultiFilter();
        sax = new TimeseriesSAX();
        sax.setNumBins(20);
        sax.setNumWindows(20);
        result[1].setSubFilters(new AbstractFilter[]{row, sax});
        result[2] = new MultiFilter();
        sax = new TimeseriesSAX();
        sax.setNumBins(5);
        sax.setNumWindows(5);
        result[2].setSubFilters(new AbstractFilter[]{row, sax});
        result[3] = new MultiFilter();
        sax = new TimeseriesSAX();
        sax.setOutputLabels(false);
        result[3].setSubFilters(new AbstractFilter[]{row, sax});
        return result;
    }

    public static Test suite() {
        return new TestSuite(TimeseriesSAXTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TimeseriesSAXTest.runTest((Test)TimeseriesSAXTest.suite());
    }
}

