/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.base.BasePassword;
import adams.core.io.PlaceholderFile;
import adams.data.DateFormatString;
import adams.data.container.DataContainer;
import adams.data.io.input.SimpleTimeseriesReader;
import adams.data.io.output.SimpleTimeseriesWriter;
import adams.data.timeseries.Timeseries;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;

public class TimeseriesTestHelper
extends AbstractTestHelper<Timeseries, Timeseries> {
    protected DateFormatString m_RegressionTimestampFormatRead = new DateFormatString("yyyy-MM-dd HH:mm:ss.S");
    protected DateFormatString m_RegressionTimestampFormatWrite = new DateFormatString("yyyy-MM-dd HH:mm:ss.S");

    public TimeseriesTestHelper(AdamsTestCase owner, String dataDir) {
        super(owner, dataDir);
    }

    public AbstractDatabaseConnection getDatabaseConnection(String url, String user, BasePassword password) {
        this.m_DatabaseConnection = DatabaseConnection.getSingleton((String)url, (String)user, (BasePassword)password);
        return this.m_DatabaseConnection;
    }

    public void setRegressionTimestampFormatRead(DateFormatString value) {
        this.m_RegressionTimestampFormatRead = value;
    }

    public DateFormatString getRegressionTimestampFormatRead() {
        return this.m_RegressionTimestampFormatRead;
    }

    public void setRegressionTimestampFormatWrite(DateFormatString value) {
        this.m_RegressionTimestampFormatWrite = value;
    }

    public DateFormatString getRegressionTimestampFormatWrite() {
        return this.m_RegressionTimestampFormatWrite;
    }

    public void connect(String url, String user, BasePassword password) {
        this.m_DatabaseConnection = DatabaseConnection.getSingleton((String)url, (String)user, (BasePassword)password);
        String lastError = this.m_DatabaseConnection.getLastConnectionError();
        if (!this.m_DatabaseConnection.isConnected()) {
            try {
                this.m_DatabaseConnection.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.m_DatabaseConnection.isConnected()) {
            if (this.m_DatabaseConnection.getLastConnectionError().length() > 0) {
                lastError = this.m_DatabaseConnection.getLastConnectionError();
            }
            throw new IllegalStateException("Failed to connect to database:\n" + this.m_DatabaseConnection.toStringShort() + " (" + lastError + ")");
        }
    }

    public Timeseries load(String filename) {
        this.copyResourceToTmp(filename);
        Timeseries result = null;
        SimpleTimeseriesReader reader = new SimpleTimeseriesReader();
        reader.setTimestampFormat(this.m_RegressionTimestampFormatRead);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        if (reader.read().size() > 0) {
            result = (Timeseries)reader.read().get(0);
        }
        reader.destroy();
        this.deleteFileFromTmp(filename);
        return result;
    }

    public boolean save(Timeseries data, String filename) {
        SimpleTimeseriesWriter writer = new SimpleTimeseriesWriter();
        writer.setTimestampFormat(this.m_RegressionTimestampFormatWrite);
        TmpFile output = new TmpFile(filename);
        writer.setOutput((PlaceholderFile)output);
        writer.write((DataContainer)data);
        boolean result = output.exists();
        writer.destroy();
        return result;
    }
}

