/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversion;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class TimeseriesToWekaInstances
extends AbstractConversion {
    private static final long serialVersionUID = 3934411483801077460L;
    protected DateFormatString m_Format;

    public String globalInfo() {
        return "Turns a timeseries into a WEKA Instances object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", (Object)new DateFormatString("yyyy-MM-dd'T'HH:mm:ss"));
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The date/time format to use in the Instances object.";
    }

    public Class accepts() {
        return Timeseries.class;
    }

    public Class generates() {
        return Instances.class;
    }

    protected Object doConvert() throws Exception {
        Timeseries series = (Timeseries)((Object)this.m_Input);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("Timestamp", this.m_Format.getValue()));
        atts.add(new Attribute("Value"));
        Instances result = new Instances(series.getID(), atts, series.size());
        for (Object obj : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)obj);
            double[] value = new double[]{point.getTimestamp().getTime(), point.getValue()};
            DenseInstance inst = new DenseInstance(1.0, value);
            result.add((Instance)inst);
        }
        return result;
    }
}

