/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.DateFormatString;
import adams.data.io.output.AbstractTimeseriesWriter;
import adams.data.report.Report;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class SimpleTimeseriesWriter
extends AbstractTimeseriesWriter {
    private static final long serialVersionUID = 2779645040618901178L;
    protected DateFormatString m_TimestampFormat;

    public String globalInfo() {
        return "Writer for the simple timeseries format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp-format", "timestampFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss.S"));
    }

    public String getFormatDescription() {
        return "Simple timeseries";
    }

    public String[] getFormatExtensions() {
        return new String[]{"sts", "sts.gz"};
    }

    public void setTimestampFormat(DateFormatString value) {
        this.m_TimestampFormat = value;
        this.reset();
    }

    public DateFormatString getTimestampFormat() {
        return this.m_TimestampFormat;
    }

    public String timestampFormatTipText() {
        return "The format to use for the timestamps.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeData(List<Timeseries> data) {
        boolean result;
        BufferedWriter writer = null;
        FileWriter fw = null;
        FileOutputStream fos = null;
        DateFormat dformat = this.m_TimestampFormat.toDateFormat();
        try {
            Timeseries series = data.get(0);
            if (this.m_Output.getName().endsWith(".gz")) {
                fos = new FileOutputStream(this.m_Output.getAbsolutePath());
                writer = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(fos)));
            } else {
                fw = new FileWriter(this.m_Output.getAbsolutePath());
                writer = new BufferedWriter(fw);
            }
            if (series.hasReport()) {
                Report report = series.getReport().getClone();
                report.setStringValue("ID", series.getID());
                Object[] lines = report.toProperties().toComment().split("\n");
                Arrays.sort(lines);
                writer.write(Utils.flatten((Object[])lines, (String)"\n"));
                writer.newLine();
            }
            writer.write("Timestamp,Value");
            writer.newLine();
            Iterator iter = series.iterator();
            while (iter.hasNext()) {
                TimeseriesPoint point = (TimeseriesPoint)((Object)iter.next());
                writer.write(Utils.doubleQuote((String)dformat.format(point.getTimestamp())));
                writer.write(",");
                writer.write(Utils.doubleToString((double)point.getValue(), (int)6));
                writer.newLine();
            }
            writer.flush();
            result = true;
        }
        catch (Exception e) {
            try {
                result = false;
                this.getLogger().log(Level.SEVERE, "Failed to write timeseries to: " + this.m_Output, e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(writer);
                FileUtils.closeQuietly(fw);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly(writer);
            FileUtils.closeQuietly((Writer)fw);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((Writer)writer);
        FileUtils.closeQuietly((Writer)fw);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

