/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractTimeseriesReader;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.chooser.TimeseriesFileChooser;
import adams.gui.menu.AbstractParameterHandlingMenuItemDefinition;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerManager;
import adams.gui.visualization.timeseries.TimeseriesExplorer;
import java.awt.Component;
import java.util.List;

public class DisplayTimeseries
extends AbstractParameterHandlingMenuItemDefinition {
    private static final long serialVersionUID = -1729389254134928064L;

    public DisplayTimeseries(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "chart.gif";
    }

    public void launch() {
        AbstractTimeseriesReader reader;
        if (this.m_Parameters.length == 1) {
            reader = null;
        } else if (this.m_Parameters.length == 2) {
            reader = (AbstractTimeseriesReader)AbstractTimeseriesReader.forCommandLine((String)this.m_Parameters[0]);
            reader.setInput(new PlaceholderFile(this.m_Parameters[1]));
        } else {
            TimeseriesFileChooser chooser = new TimeseriesFileChooser();
            int retVal = chooser.showOpenDialog(null);
            if (retVal != 0) {
                return;
            }
            reader = (AbstractTimeseriesReader)((Object)chooser.getReader());
        }
        TimeseriesExplorer panel = new TimeseriesExplorer();
        ChildFrame frame = this.createChildFrame((Component)((Object)panel), 800, 600);
        frame.setJMenuBar(null);
        List chroms = reader.read();
        TimeseriesContainerManager manager = panel.getContainerManager();
        manager.startUpdate();
        for (int i = 0; i < chroms.size(); ++i) {
            AbstractContainer cont = manager.newContainer((Comparable)chroms.get(i));
            manager.add(cont);
        }
        manager.finishUpdate();
    }

    public String getTitle() {
        return "Display Timeseries";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    public String getCategory() {
        return "Visualization";
    }
}

