/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.flow.core.Actor;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.FlowAwarePaintlet;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import adams.gui.visualization.timeseries.TimeseriesPaintlet;
import java.awt.Graphics;

public class PaintletWithFixedYRange
extends AbstractTimeseriesPaintlet
implements adams.gui.visualization.core.PaintletWithFixedYRange,
FlowAwarePaintlet {
    private static final long serialVersionUID = 354723429582771889L;
    protected double m_MinY;
    protected double m_MaxY;
    protected AbstractTimeseriesPaintlet m_Paintlet;
    protected Actor m_Actor;

    public String globalInfo() {
        return "Meta-paintlet that uses a fixed Y range (for faster drawing) and a base-paintlet to draw the actual data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-y", "minY", (Object)0.0, null, null);
        this.m_OptionManager.add("max-y", "maxY", (Object)1000.0, null, null);
        this.m_OptionManager.add("paintlet", "paintlet", (Object)this.getDefaultPaintlet());
    }

    protected void initialize() {
        this.setPaintlet(this.getDefaultPaintlet());
        super.initialize();
    }

    protected AbstractTimeseriesPaintlet getDefaultPaintlet() {
        return new TimeseriesPaintlet();
    }

    public void setPanel(PaintablePanel value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(value);
        }
        super.setPanel(value);
    }

    public void setMinY(double value) {
        this.m_MinY = value;
        this.memberChanged(true);
    }

    public double getMinY() {
        return this.m_MinY;
    }

    public double getMinimumY() {
        return this.m_MinY;
    }

    public String minYTipText() {
        return "The minimum value for the Y range.";
    }

    public void setMaxY(double value) {
        this.m_MaxY = value;
        this.memberChanged(true);
    }

    public double getMaxY() {
        return this.m_MaxY;
    }

    public double getMaximumY() {
        return this.m_MaxY;
    }

    public String maxYTipText() {
        return "The maximum value for the Y range.";
    }

    public void setPaintlet(AbstractTimeseriesPaintlet value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(null);
        }
        this.m_Paintlet = value;
        this.m_Paintlet.setPanel(this.getPanel());
        this.memberChanged();
    }

    public AbstractTimeseriesPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The actual paintlet to use for drawing the data.";
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        this.m_Paintlet.performPaint(g, moment);
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        if (this.m_Paintlet != null) {
            return this.m_Paintlet.getPaintMoment();
        }
        return PaintEvent.PaintMoment.PAINT;
    }

    public void setActor(Actor actor) {
        this.m_Actor = actor;
    }

    public Actor getActor() {
        return this.m_Actor;
    }
}

