/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.DateUtils;
import adams.core.base.BaseDateTime;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.Date;

public class TimeseriesWindow
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected BaseDateTime m_Start;
    protected BaseDateTime m_End;
    protected boolean m_Invert;

    public String globalInfo() {
        return "Leaves only the specified window in the timeseries (borders included).\nThe matching can be inverted, i.e., everything but the window is returned.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", (Object)new BaseDateTime("-INF"));
        this.m_OptionManager.add("end", "end", (Object)new BaseDateTime("+INF"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public void setStart(BaseDateTime value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseDateTime getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The timestamp for the first data point in series to keep.";
    }

    public void setEnd(BaseDateTime value) {
        this.m_End = value;
        this.reset();
    }

    public BaseDateTime getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The timestamp for the last data point in series to keep.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, everything but the window is kept.";
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        Date start = this.m_Start.dateValue();
        Date end = this.m_End.dateValue();
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            if (this.m_Invert ? !DateUtils.isBefore((Date)start, (Date)point.getTimestamp()) && !DateUtils.isAfter((Date)end, (Date)point.getTimestamp()) : DateUtils.isBefore((Date)start, (Date)point.getTimestamp()) || DateUtils.isAfter((Date)end, (Date)point.getTimestamp())) continue;
            result.add((DataPoint)new TimeseriesPoint(point.getTimestamp(), point.getValue()));
        }
        return result;
    }
}

