/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.container.DataPoint;
import adams.data.io.input.AbstractTimeseriesReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.MetaFileReader;
import adams.data.io.input.MultiSheetSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

public class SpreadSheetTimeseriesReader
extends AbstractTimeseriesReader
implements MetaFileReader {
    private static final long serialVersionUID = -1030024345072684197L;
    protected SpreadSheetReader m_Reader;
    protected String m_ColumnID;
    protected int m_ColumnIDIndex;
    protected String m_ColumnTimestamp;
    protected int m_ColumnTimestampIndex;
    protected String m_ColumnValue;
    protected int m_ColumnValueIndex;
    protected Timeseries m_Timeseries;
    protected int m_RowIndex;

    public String globalInfo() {
        return "Reads timeseries containers from columns of a spreadsheet.\nA new container is started, whenever the value of the ID column changes (hence you need to ensure that the data is ordered on this column).\nHowever, it is not required to have an ID column present. In this case, all of the data gets added to the same timeseries.";
    }

    public String getFormatDescription() {
        return "Spreadsheet timeseries";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    public String[] getActualFormatExtensions() {
        return this.m_Reader.getFormatExtensions();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("column-id", "columnID", (Object)"id");
        this.m_OptionManager.add("column-timestamp", "columnTimestamp", (Object)"timestamp");
        this.m_OptionManager.add("column-value", "columnValue", (Object)"value");
    }

    protected void reset() {
        super.reset();
        this.m_Timeseries = null;
        this.m_ColumnIDIndex = -1;
        this.m_ColumnTimestampIndex = -1;
        this.m_ColumnValueIndex = -1;
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the spreadsheet file.";
    }

    public void setColumnID(String value) {
        this.m_ColumnID = value;
        this.reset();
    }

    public String getColumnID() {
        return this.m_ColumnID;
    }

    public String columnIDTipText() {
        return "The name of the (optional) column containing the ID that distinguishes the timeseries.";
    }

    public void setColumnTimestamp(String value) {
        this.m_ColumnTimestamp = value;
        this.reset();
    }

    public String getColumnTimestamp() {
        return this.m_ColumnTimestamp;
    }

    public String columnTimestampTipText() {
        return "The name of the column containing the timestamp for a data point (accepted types: integer, date, time, datetime, timestamp).";
    }

    public void setColumnValue(String value) {
        this.m_ColumnValue = value;
        this.reset();
    }

    public String getColumnValue() {
        return this.m_ColumnValue;
    }

    public String columnValueTipText() {
        return "The name of the column containing the value for a data point (accepted types: numeric).";
    }

    protected TimeseriesPoint readDataPoint(SpreadSheet sheet) throws Exception {
        Date timestamp;
        Cell cell = sheet.getCell(this.m_RowIndex, this.m_ColumnTimestampIndex);
        switch (cell.getContentType()) {
            case DATE: 
            case TIME: 
            case DATETIME: 
            case DATETIMEMSEC: {
                timestamp = cell.toAnyDateType();
                break;
            }
            case LONG: 
            case DOUBLE: {
                timestamp = new Date(cell.toDouble().longValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled column type: " + cell.getContentType());
            }
        }
        cell = sheet.getCell(this.m_RowIndex, this.m_ColumnValueIndex);
        double val = cell.toDouble();
        TimeseriesPoint result = new TimeseriesPoint(timestamp, val);
        return result;
    }

    protected void performRead(SpreadSheet sheet) throws Exception {
        String id = null;
        String idOld = null;
        this.m_RowIndex = 0;
        if (this.m_ColumnIDIndex == -1) {
            id = sheet.getName() != null ? sheet.getName() : this.m_Input.getName();
        }
        while (this.m_RowIndex < sheet.getRowCount()) {
            if (this.m_ColumnIDIndex != -1 && !sheet.hasCell(this.m_RowIndex, this.m_ColumnIDIndex)) {
                ++this.m_RowIndex;
                continue;
            }
            if (this.m_ColumnIDIndex != -1) {
                idOld = id;
                id = sheet.getCell(this.m_RowIndex, this.m_ColumnIDIndex).getContent();
            }
            TimeseriesPoint point = this.readDataPoint(sheet);
            if (!id.equals(idOld)) {
                this.m_Timeseries = new Timeseries();
                this.m_Timeseries.setID(id);
                this.m_Timeseries.add((DataPoint)point);
                this.m_ReadData.add(this.m_Timeseries);
            } else {
                this.m_Timeseries.add((DataPoint)point);
            }
            if (this.m_ColumnIDIndex == -1) {
                idOld = id;
            }
            ++this.m_RowIndex;
        }
    }

    protected void analyzeColumns(SpreadSheet sheet) throws Exception {
        this.m_ColumnIDIndex = sheet.getHeaderRow().indexOfContent(this.m_ColumnID);
        this.m_ColumnTimestampIndex = sheet.getHeaderRow().indexOfContent(this.m_ColumnTimestamp);
        this.m_ColumnValueIndex = sheet.getHeaderRow().indexOfContent(this.m_ColumnValue);
        if (this.m_ColumnTimestampIndex == -1) {
            throw new IllegalStateException("Timestamp column '" + this.m_ColumnTimestamp + "' not found in results set!");
        }
        if (this.m_ColumnValueIndex == -1) {
            throw new IllegalStateException("Value column '" + this.m_ColumnValue + "' not found in results set!");
        }
        if (!sheet.isNumeric(this.m_ColumnValueIndex)) {
            throw new IllegalStateException("Value column '" + this.m_ColumnValue + "' must be numeric!");
        }
    }

    protected void readData() {
        try {
            List sheets;
            if (this.m_Reader instanceof MultiSheetSpreadSheetReader) {
                sheets = ((MultiSheetSpreadSheetReader)this.m_Reader).readRange((File)this.m_Input);
            } else {
                sheets = new ArrayList<SpreadSheet>();
                sheets.add(this.m_Reader.read((File)this.m_Input));
            }
            for (SpreadSheet sheet : sheets) {
                this.analyzeColumns(sheet);
                this.performRead(sheet);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read file: " + this.m_Input, e);
        }
    }
}

