/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.ArrayList;
import java.util.List;

public class TimeseriesRange
extends AbstractOutlierDetector<Timeseries> {
    private static final long serialVersionUID = -5300001549269138646L;
    protected double m_Min;
    protected double m_Max;

    public String globalInfo() {
        return "Ensures that timeseries values lie within the defined range.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min", "min", (Object)Double.MIN_VALUE);
        this.m_OptionManager.add("max", "max", (Object)Double.MAX_VALUE);
    }

    public void setMin(double value) {
        this.m_Min = value;
        this.reset();
    }

    public double getMin() {
        return this.m_Min;
    }

    public String minTipText() {
        return "The minimum value to accept.";
    }

    public void setMax(double value) {
        this.m_Max = value;
        this.reset();
    }

    public double getMax() {
        return this.m_Max;
    }

    public String maxTipText() {
        return "The maximum value accept.";
    }

    protected void checkData(Timeseries data) {
        super.checkData((DataContainer)data);
        if (this.m_Min >= this.m_Max) {
            throw new IllegalStateException("Maximum must be larger than minimum: " + this.m_Max + " > " + this.m_Min);
        }
    }

    protected List<String> processData(Timeseries data) {
        ArrayList<String> result = new ArrayList<String>();
        DateFormat dformat = DateUtils.getTimestampFormatter();
        String msg = null;
        List points = data.toList();
        for (TimeseriesPoint point : points) {
            if (point.getValue() < this.m_Min) {
                msg = "Value at " + dformat.format(point.getTimestamp()) + " is below " + this.m_Min + ": " + point.getValue();
                break;
            }
            if (!(point.getValue() > this.m_Max)) continue;
            msg = "Value at " + dformat.format(point.getTimestamp()) + " is above " + this.m_Max + ": " + point.getValue();
            break;
        }
        if (msg != null) {
            result.add(msg);
            if (this.isLoggingEnabled()) {
                this.getLogger().info(data.getDatabaseID() + " - " + ((Object)((Object)this)).getClass().getName() + ": " + msg);
            }
        }
        return result;
    }
}

