/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.timeseriessplit;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.transformer.timeseriessplit.AbstractTimeseriesSplitter;
import java.util.ArrayList;

public class FixedNumSegments
extends AbstractTimeseriesSplitter {
    private static final long serialVersionUID = 259240444289354690L;
    protected int m_NumSegments;

    public String globalInfo() {
        return "Splits the timeseries into a fixed number of same-sized segements.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-segments", "numSegments", (Object)2, (Number)1, null);
    }

    public void setNumSegments(int value) {
        if (value >= 1) {
            this.m_NumSegments = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of segments must be at least 1, provided: " + value);
        }
    }

    public int getNumSegments() {
        return this.m_NumSegments;
    }

    public String numSegmentsTipText() {
        return "The number of segments to generate.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"numSegments", (Object)this.m_NumSegments, (String)"# segments: ");
    }

    @Override
    protected Timeseries[] doSplit(Timeseries series) {
        ArrayList<Timeseries> result = new ArrayList<Timeseries>();
        Timeseries current = null;
        double numPoints = (double)series.size() / (double)this.m_NumSegments;
        double max = 0.0;
        int offset = 0;
        for (int i = 0; i < this.m_NumSegments; ++i) {
            max += numPoints;
            if (i == this.m_NumSegments - 1) {
                max = series.size();
            }
            current = series.getHeader();
            result.add(current);
            int n = offset;
            while ((double)n < max) {
                TimeseriesPoint point = (TimeseriesPoint)((Object)series.toList().get(n));
                current.add((DataPoint)point.getClone());
                ++n;
            }
            offset += current.size();
        }
        return result.toArray(new Timeseries[result.size()]);
    }
}

