/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.Properties;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.SQL;
import adams.gui.core.BaseDialog;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.wizard.AbstractDatabaseConnectionPage;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.DatabaseConnectionPage;
import adams.gui.wizard.ListPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.ParameterPanelPage;
import adams.gui.wizard.ProceedAction;
import adams.gui.wizard.StartPage;
import adams.gui.wizard.WizardPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;

public class TimeseriesImportDatabaseDialog
extends BaseDialog {
    private static final long serialVersionUID = 8033226799557584214L;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final String QUERY_IDS = "queryIDs";
    public static final String QUERY_DATA = "queryData";
    public static final String QUERY_METADATA_KEYVALUE = "queryMetaDataKeyValue";
    public static final String QUERY_METADATA_ROW = "queryMetaDataRow";
    protected WizardPane m_PaneWizard;
    protected DatabaseConnectionPage m_PageConnection;
    protected ParameterPanelPage m_PageQueries;
    protected ListPage m_PageIDs;
    protected int m_Option;

    public TimeseriesImportDatabaseDialog() {
    }

    public TimeseriesImportDatabaseDialog(Dialog owner) {
        super(owner);
    }

    public TimeseriesImportDatabaseDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public TimeseriesImportDatabaseDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public TimeseriesImportDatabaseDialog(Dialog owner, String title, Dialog.ModalityType modality) {
        super(owner, title, modality);
    }

    public TimeseriesImportDatabaseDialog(Frame owner) {
        super(owner);
    }

    public TimeseriesImportDatabaseDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public TimeseriesImportDatabaseDialog(Frame owner, String title) {
        super(owner, title);
    }

    public TimeseriesImportDatabaseDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    protected void initialize() {
        super.initialize();
        this.m_Option = 2;
    }

    protected void initGUI() {
        super.initGUI();
        this.setDefaultCloseOperation(2);
        this.m_PaneWizard = new WizardPane();
        this.m_PaneWizard.setCustomFinishText("Load");
        StartPage start = new StartPage();
        start.setLogo(null);
        start.setPageName("Start");
        start.setDescription("<html>\nThis wizard will guide you through the process of loading timeseries data from a database using SQL queries. Optional meta-data can be added to the data using further queries.<br>\n<br>\nYou can save/load setups which will allow you to keep track of the various SQL statements for different databases. Just use the load/save buttons at the bottom of a page.<br>\n<br>\nPlease click on <b>Next</b> to continue.</html>");
        this.m_PaneWizard.addPage((AbstractWizardPage)start);
        this.m_PageConnection = new DatabaseConnectionPage();
        this.m_PageConnection.setPageCheck((PageCheck)new AbstractDatabaseConnectionPage.DatabaseConnectionPageCheck());
        this.m_PaneWizard.addPage((AbstractWizardPage)this.m_PageConnection);
        ParameterPanelPage param = new ParameterPanelPage();
        param.setPageName("Queries");
        param.setDescription("Please enter the queries to retrieve data from the database. You can use the placeholder '{ID}' in your SQL statements for reading the timeseries data and meta-data.\nIf no meta-data available, leave the meta-data statements empty. Otherwise, either use the statement that returns mulitple rows of key-value pairs or the one that returns a single row with all the meta-data columns (uses the column name as key).");
        param.getParameterPanel().addPropertyType(QUERY_IDS, PropertiesParameterPanel.PropertyType.SQL);
        param.getParameterPanel().setLabel(QUERY_IDS, "Listing the IDs");
        param.getParameterPanel().addPropertyType(QUERY_DATA, PropertiesParameterPanel.PropertyType.SQL);
        param.getParameterPanel().setLabel(QUERY_DATA, "Timeseries data");
        param.getParameterPanel().addPropertyType(QUERY_METADATA_KEYVALUE, PropertiesParameterPanel.PropertyType.SQL);
        param.getParameterPanel().setLabel(QUERY_METADATA_KEYVALUE, "Meta-data (key-value)");
        param.getParameterPanel().addPropertyType(QUERY_METADATA_ROW, PropertiesParameterPanel.PropertyType.SQL);
        param.getParameterPanel().setLabel(QUERY_METADATA_ROW, "Meta-data (row)");
        param.getParameterPanel().setPropertyOrder(new String[]{QUERY_IDS, QUERY_DATA, QUERY_METADATA_KEYVALUE, QUERY_METADATA_ROW});
        Properties props = new Properties();
        props.setProperty(QUERY_IDS, "select ID from table1 order by ID");
        props.setProperty(QUERY_DATA, "select timestamp,value from table1 where ID = {ID}");
        props.setProperty(QUERY_METADATA_KEYVALUE, "select key,value from table2 where ID = {ID}");
        props.setProperty(QUERY_METADATA_ROW, "select * from table2 where ID = {ID}");
        param.setProperties(props);
        param.getParameterPanel().setDefaultSQLDimension(new Dimension(200, 80));
        param.setProceedAction(new ProceedAction(){

            public void onProceed(AbstractWizardPage currPage, AbstractWizardPage nextPage) {
                Properties props = TimeseriesImportDatabaseDialog.this.m_PageConnection.getProperties();
                DatabaseConnection conn = new DatabaseConnection(props.getProperty("connectionURL"), props.getProperty("connectionUser"), props.getPassword("connectionPassword"));
                try {
                    conn.connect();
                    props = TimeseriesImportDatabaseDialog.this.m_PageQueries.getProperties();
                    SQL sql = new SQL((AbstractDatabaseConnection)conn);
                    ResultSet rs = sql.getResultSet(props.getProperty(TimeseriesImportDatabaseDialog.QUERY_IDS));
                    ArrayList<String> ids = new ArrayList<String>();
                    while (rs.next()) {
                        ids.add("" + rs.getObject(1));
                    }
                    SQL.closeAll((ResultSet)rs);
                    TimeseriesImportDatabaseDialog.this.m_PageIDs.setValues(ids);
                }
                catch (Exception e) {
                    currPage.getLogger().log(Level.SEVERE, "Failed to retrieve IDs!", e);
                }
            }
        });
        this.m_PaneWizard.addPage((AbstractWizardPage)param);
        this.m_PageQueries = param;
        this.m_PageIDs = new ListPage();
        this.m_PageIDs.setSelectionMode(2);
        this.m_PageIDs.setPageName("Select IDs");
        this.m_PageIDs.setDescription("Please select the IDs of the timeseries to load.");
        this.m_PageIDs.setPageCheck((PageCheck)new PageCheck<ListPage>(){

            public boolean checkPage(ListPage page) {
                return page.getList().getSelectedIndices().length > 0;
            }
        });
        this.m_PaneWizard.addPage((AbstractWizardPage)this.m_PageIDs);
        this.getContentPane().add((Component)this.m_PaneWizard, "Center");
        this.m_PaneWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Finish")) {
                    TimeseriesImportDatabaseDialog.this.m_Option = 0;
                }
                TimeseriesImportDatabaseDialog.this.setVisible(false);
            }
        });
    }

    public int getOption() {
        return this.m_Option;
    }

    protected void beforeShow() {
        super.beforeShow();
        this.m_Option = 2;
    }

    public WizardPane getWizard() {
        return this.m_PaneWizard;
    }

    public DatabaseConnectionPage getConnectionPage() {
        return this.m_PageConnection;
    }

    public ParameterPanelPage getQueriesPage() {
        return this.m_PageQueries;
    }

    public ListPage getIDsPage() {
        return this.m_PageIDs;
    }

    public Properties getProperties(boolean usePrefix) {
        return this.m_PaneWizard.getProperties(usePrefix);
    }
}

