/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.RoundingType;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;

public class TimeseriesRound
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected RoundingType m_Type;

    public String globalInfo() {
        return "Rounds the values of the timeseries points.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)RoundingType.ROUND);
    }

    public void setType(RoundingType value) {
        this.m_Type = value;
        this.reset();
    }

    public RoundingType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of rounding to perform.";
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            double value = point.getValue();
            switch (this.m_Type) {
                case ROUND: {
                    value = Math.round(value);
                    break;
                }
                case CEILING: {
                    value = Math.ceil(value);
                    break;
                }
                case FLOOR: {
                    value = Math.floor(value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled rounding type: " + this.m_Type);
                }
            }
            result.add((DataPoint)new TimeseriesPoint(point.getTimestamp(), value));
        }
        return result;
    }
}

