/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractDataStatistic;
import adams.data.statistics.StatUtils;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.List;

public class TimeseriesStatistic<T extends Timeseries>
extends AbstractDataStatistic<T> {
    private static final long serialVersionUID = -2482267274581297567L;
    public static final String DATABASE_ID = "Database ID";
    public static final String NUMBER_OF_POINTS = "Number of points";
    public static final String MIN_VALUE = "min Value";
    public static final String MAX_VALUE = "max Value";
    public static final String MEAN_VALUE = "mean Value";
    public static final String STDEV_VALUE = "stdev Value";
    public static final String MEDIAN_VALUE = "median Value";
    public static final String MEDIAN_DELTA_TIMESTAMP = "median delta Timestamp";
    public static final String STDEV_DELTA_TIMESTAMP = "stdev delta Timestamp";
    public static final String MEAN_DELTA_TIMESTAMP = "mean delta Timestamp";
    public static final String MAX_DELTA_TIMESTAMP = "max delta Timestamp";
    public static final String MIN_DELTA_TIMESTAMP = "min delta Timestamp";

    public TimeseriesStatistic() {
    }

    public TimeseriesStatistic(T data) {
        super(data);
    }

    public String globalInfo() {
        return "Calculates a few statistics for a timeseries.";
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Data = null;
    }

    public void setData(T value) {
        this.m_Calculated = false;
        this.m_Data = value;
    }

    public T getData() {
        return (T)((Object)((Timeseries)this.m_Data));
    }

    public String getStatisticDescription() {
        return ((Timeseries)this.m_Data).getID() + " (" + ((Timeseries)this.m_Data).getDatabaseID() + ")";
    }

    protected void calculate() {
        super.calculate();
        if (this.m_Data == null) {
            return;
        }
        List points = ((Timeseries)this.m_Data).toList();
        Number[] values = new Double[]{};
        Number[] deltaTime = new Double[]{};
        if (points.size() > 0) {
            values = new Double[points.size()];
            deltaTime = new Double[points.size() - 1];
            for (int i = 0; i < points.size(); ++i) {
                values[i] = ((TimeseriesPoint)((Object)points.get(i))).getValue();
                if (i <= 0) continue;
                deltaTime[i - 1] = (double)((TimeseriesPoint)((Object)points.get(i))).getTimestamp().getTime() - (double)((TimeseriesPoint)((Object)points.get(i - 1))).getTimestamp().getTime();
            }
        }
        this.add(DATABASE_ID, ((Timeseries)this.m_Data).getDatabaseID());
        this.add(NUMBER_OF_POINTS, points.size());
        this.add(MIN_VALUE, ((Timeseries)this.m_Data).getMinValue() != null ? ((Timeseries)this.m_Data).getMinValue().getValue() : Double.NaN);
        this.add(MAX_VALUE, ((Timeseries)this.m_Data).getMaxValue() != null ? ((Timeseries)this.m_Data).getMaxValue().getValue() : Double.NaN);
        this.add(MEAN_VALUE, this.numberToDouble(StatUtils.mean((Number[])values)));
        this.add(STDEV_VALUE, this.numberToDouble(StatUtils.stddev((Number[])values, (boolean)true)));
        this.add(MEDIAN_VALUE, this.numberToDouble(StatUtils.median((Number[])values)));
        this.add(MIN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.min((Number[])deltaTime)));
        this.add(MAX_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.max((Number[])deltaTime)));
        this.add(MEAN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.mean((Number[])deltaTime)));
        this.add(STDEV_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.stddev((Number[])deltaTime, (boolean)true)));
        this.add(MEDIAN_DELTA_TIMESTAMP, this.numberToDouble(StatUtils.median((Number[])deltaTime)));
        values = null;
    }
}

