/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Utils;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.container.AbstractDataContainer;
import adams.data.container.DataContainer;
import adams.data.id.MutableDatabaseIDHandler;
import adams.data.id.MutableIDHandler;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.statistics.InformativeStatisticSupporter;
import adams.data.statistics.TimeseriesStatistic;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesPointComparator;
import adams.data.timeseries.TimeseriesUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Timeseries<P extends TimeseriesPoint, R extends Report, S extends TimeseriesStatistic>
extends AbstractDataContainer<P>
implements MutableReportHandler<R>,
MutableDatabaseIDHandler,
NotesHandler,
SpreadSheetSupporter,
InformativeStatisticSupporter<TimeseriesStatistic> {
    private static final long serialVersionUID = -915092788633841806L;
    protected static TimeseriesPointComparator m_Comparator;
    protected int m_DatabaseID;
    protected R m_Report;
    protected Notes m_Notes;
    protected TimeseriesPoint m_MaxValue;
    protected TimeseriesPoint m_MinValue;

    public Timeseries() {
        this("none");
    }

    public Timeseries(String id) {
        if (m_Comparator == null) {
            m_Comparator = this.newComparator();
        }
        this.setID(id);
        this.setReport(this.newReport());
        this.setDatabaseID(-1);
        this.m_Notes = new Notes();
        this.m_MinValue = null;
        this.m_MaxValue = null;
    }

    protected R newReport() {
        return (R)new Report();
    }

    protected boolean modifiedListener(boolean modified) {
        if (modified) {
            this.invalidateMinMax();
        }
        return modified;
    }

    public TimeseriesPointComparator newComparator() {
        return new TimeseriesPointComparator();
    }

    public TimeseriesPointComparator getComparator() {
        return m_Comparator;
    }

    public P newPoint() {
        return (P)((Object)new TimeseriesPoint());
    }

    protected synchronized void invalidateMinMax() {
        this.m_MinValue = null;
        this.m_MaxValue = null;
    }

    protected synchronized void validateMinMax() {
        if (this.m_MinValue != null) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)iterator.next());
            if (this.m_MaxValue == null || point.getValue() > this.m_MaxValue.getValue()) {
                this.m_MaxValue = point;
            }
            if (this.m_MinValue != null && !(point.getValue() < this.m_MinValue.getValue())) continue;
            this.m_MinValue = point;
        }
    }

    public TimeseriesPoint getMaxValue() {
        this.validateMinMax();
        return this.m_MaxValue;
    }

    public TimeseriesPoint getMinValue() {
        this.validateMinMax();
        return this.m_MinValue;
    }

    public void assign(DataContainer<P> other) {
        super.assign(other);
        Timeseries cont = (Timeseries)other;
        this.setDatabaseID(cont.getDatabaseID());
        if (cont.hasReport()) {
            this.setReport(cont.getReport().getClone());
        }
        this.m_Notes = new Notes();
        this.m_Notes.mergeWith(cont.getNotes());
    }

    public Timeseries getHeader() {
        Timeseries<P, R, S> result = new Timeseries<P, R, S>();
        result.assign((DataContainer<P>)this);
        return result;
    }

    public boolean hasReport() {
        return this.m_Report != null;
    }

    public void setReport(R value) {
        this.m_Report = value;
    }

    public R getReport() {
        return this.m_Report;
    }

    public int getDatabaseID() {
        return this.m_DatabaseID;
    }

    public void setDatabaseID(int value) {
        this.m_DatabaseID = value;
        if (this.m_Report != null) {
            this.m_Report.setDatabaseID(value);
            this.m_Report.update();
        }
    }

    public void setID(String value) {
        super.setID(value);
        if (this.m_Report != null) {
            if (this.m_Report instanceof MutableIDHandler) {
                ((MutableIDHandler)this.m_Report).setID(value);
            }
            this.m_Report.update();
        }
    }

    public int compareToHeader(Object o) {
        int result = super.compareToHeader(o);
        if (result != 0) {
            return result;
        }
        Timeseries tp = (Timeseries)((Object)o);
        if (result == 0) {
            result = new Integer(this.getDatabaseID()).compareTo(new Integer(tp.getDatabaseID()));
        }
        if (result == 0) {
            result = Utils.compare(this.getReport(), tp.getReport());
        }
        return result;
    }

    public S toStatistic() {
        return (S)((Object)new TimeseriesStatistic<Timeseries>(this));
    }

    public TimeseriesPoint find(Date timestamp) {
        TimeseriesPoint result = null;
        int index = TimeseriesUtils.findTimestamp((List<TimeseriesPoint>)this.m_Points, timestamp);
        if (index > -1) {
            result = (TimeseriesPoint)((Object)this.m_Points.get(index));
        }
        return result;
    }

    public TimeseriesPoint findClosest(Date timestamp) {
        TimeseriesPoint result = null;
        int index = TimeseriesUtils.findClosestTimestamp(this.m_Points, timestamp);
        if (index > -1) {
            result = (TimeseriesPoint)((Object)this.m_Points.get(index));
        }
        return result;
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public SpreadSheet toSpreadSheet() {
        SpreadSheet result = new SpreadSheet();
        result.setName(this.getID());
        if (this.hasReport()) {
            result.addComment(this.getReport().toString());
        } else {
            result.addComment(this.getID());
        }
        HeaderRow row = result.getHeaderRow();
        row.addCell("D").setContent("Timestamp");
        row.addCell("V").setContent("Value");
        DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
        for (int i = 0; i < this.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)this.toList().get(i));
            row = result.addRow();
            row.addCell("D").setContent(dformat.format(point.getTimestamp()));
            row.addCell("V").setContent(Double.valueOf(point.getValue()));
        }
        return result;
    }
}

