/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.Properties;
import adams.core.Range;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.io.output.AbstractTimeseriesWriter;
import adams.data.io.output.MetaFileWriter;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.data.statistics.InformativeStatistic;
import adams.data.timeseries.PeriodicityHelper;
import adams.data.timeseries.PeriodicityType;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.DataContainerPanelWithSidePanel;
import adams.gui.visualization.container.NotesFactory;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.CoordinatesPaintlet;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.report.ReportContainer;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.statistics.HistogramFactory;
import adams.gui.visualization.statistics.InformativeStatisticFactory;
import adams.gui.visualization.timeseries.PeriodicityColorProvider;
import adams.gui.visualization.timeseries.PeriodicityPaintlet;
import adams.gui.visualization.timeseries.SelectedTimestampPaintlet;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerList;
import adams.gui.visualization.timeseries.TimeseriesContainerManager;
import adams.gui.visualization.timeseries.TimeseriesExportDialog;
import adams.gui.visualization.timeseries.TimeseriesPaintlet;
import adams.gui.visualization.timeseries.TimeseriesPointHitDetector;
import adams.gui.visualization.timeseries.TimeseriesZoomOverviewPanel;
import gnu.trove.list.array.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TimeseriesPanel<T extends Timeseries, M extends TimeseriesContainerManager<C>, C extends TimeseriesContainer>
extends DataContainerPanelWithSidePanel<T, M>
implements PaintListener,
ContainerListPopupMenuSupplier<M, C>,
PopupMenuCustomizer,
TipTextCustomizer {
    private static final long serialVersionUID = -9059718549932104312L;
    protected boolean m_AdjustToVisibleData;
    protected CoordinatesPaintlet m_CoordinatesPaintlet;
    protected TimeseriesPaintlet m_TimeseriesPaintlet;
    protected PeriodicityPaintlet m_PeriodicityPaintlet;
    protected SelectedTimestampPaintlet m_SelectedTimestampPaintlet;
    protected TimeseriesContainerList m_TimeseriesContainerList;
    protected HistogramFactory.SetupDialog m_HistogramSetup;
    protected TimeseriesPointHitDetector m_TimeseriesPointHitDetector;
    protected int m_ToolTipMaxColumns;
    protected TimeseriesZoomOverviewPanel m_PanelZoomOverview;
    protected TimeseriesExportDialog m_ExportDialog;

    public TimeseriesPanel() {
    }

    public TimeseriesPanel(String title) {
        super(title);
    }

    protected void initialize() {
        super.initialize();
        this.m_AdjustToVisibleData = true;
        this.m_HistogramSetup = null;
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    protected M newContainerManager() {
        return (M)((Object)new TimeseriesContainerManager(this, this.getDatabaseConnection()));
    }

    public TimeseriesPaintlet getContainerPaintlet() {
        return this.m_TimeseriesPaintlet;
    }

    public PeriodicityPaintlet getPeriodicityPaintlet() {
        return this.m_PeriodicityPaintlet;
    }

    protected boolean hasSidePanel() {
        return true;
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.m_ToolTipMaxColumns = props.getInteger("Plot.ToolTip.MaxColumns", Integer.valueOf(80));
        this.setAdjustToVisibleData(props.getBoolean("Plot.AdjustToVisibleData", Boolean.valueOf(false)));
        this.m_TimeseriesContainerList = new TimeseriesContainerList();
        this.m_TimeseriesContainerList.setManager(this.getContainerManager());
        this.m_TimeseriesContainerList.setAllowSearch(props.getBoolean("ContainerList.AllowSearch", Boolean.valueOf(false)));
        this.m_TimeseriesContainerList.setPopupMenuSupplier(this);
        this.m_TimeseriesContainerList.setDisplayDatabaseID(true);
        this.m_TimeseriesContainerList.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                final ContainerTable table = TimeseriesPanel.this.m_TimeseriesContainerList.getTable();
                if (table.getRowCount() > 0 && table.getSelectedRowCount() == 0) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            table.getSelectionModel().addSelectionInterval(0, 0);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        this.m_SidePanel.setLayout(new BorderLayout(0, 0));
        this.m_SidePanel.add((Component)((Object)this.m_TimeseriesContainerList));
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        panel.setPreferredSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        this.m_SidePanel.add((Component)panel, "South");
        this.m_TimeseriesPaintlet = new TimeseriesPaintlet();
        this.m_TimeseriesPaintlet.setStrokeThickness(props.getDouble("Plot.StrokeThickness", Double.valueOf(1.0)).floatValue());
        this.m_TimeseriesPaintlet.setPanel((PaintablePanel)this);
        this.m_TimeseriesPaintlet.setAntiAliasingEnabled(props.getBoolean("Plot.AntiAliasing", Boolean.valueOf(true)));
        this.m_PeriodicityPaintlet = new PeriodicityPaintlet();
        this.m_PeriodicityPaintlet.setPanel((PaintablePanel)this);
        this.m_PeriodicityPaintlet.setPeriodicity(PeriodicityType.valueOf(props.getProperty("Plot.Periodicity", PeriodicityType.NONE.toString())));
        this.m_PeriodicityPaintlet.setColorProvider(AbstractColorProvider.forCommandLine((String)props.getProperty("Plot.PeriodicityColorProvider", OptionUtils.getCommandLine((Object)((Object)new PeriodicityColorProvider())))));
        this.getPlot().getAxis(Axis.BOTTOM).setNumberFormat(PeriodicityHelper.getFormat(this.m_PeriodicityPaintlet.getPeriodicity()));
        this.m_SelectedTimestampPaintlet = new SelectedTimestampPaintlet();
        this.m_SelectedTimestampPaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet = new CoordinatesPaintlet();
        this.m_CoordinatesPaintlet.setYInvisible(true);
        this.m_CoordinatesPaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet.setXColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.X, Color.DARK_GRAY));
        this.m_CoordinatesPaintlet.setYColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.Y, Color.DARK_GRAY));
        this.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
        try {
            ((TimeseriesContainerManager)this.getContainerManager()).setColorProvider((AbstractColorProvider)OptionUtils.forAnyCommandLine(AbstractColorProvider.class, (String)props.getProperty("Plot.ColorProvider", DefaultColorProvider.class.getName())));
        }
        catch (Exception e) {
            System.err.println(((Object)((Object)this)).getClass().getName() + " - Failed to set the color provider:");
            ((TimeseriesContainerManager)this.getContainerManager()).setColorProvider((AbstractColorProvider)new DefaultColorProvider());
        }
        this.m_TimeseriesPointHitDetector = new TimeseriesPointHitDetector(this);
        this.getPlot().setTipTextCustomizer((TipTextCustomizer)this);
        this.m_PanelZoomOverview = new TimeseriesZoomOverviewPanel();
        this.m_PlotWrapperPanel.add((Component)((Object)this.m_PanelZoomOverview), (Object)"South");
        this.m_PanelZoomOverview.setDataContainerPanel((DataContainerPanel)this);
    }

    public TimeseriesPaintlet getTimeseriesPaintlet() {
        return this.m_TimeseriesPaintlet;
    }

    public SelectedTimestampPaintlet getSelectedTimestampPaintlet() {
        return this.m_SelectedTimestampPaintlet;
    }

    public void setAdjustToVisibleData(boolean value) {
        this.m_AdjustToVisibleData = value;
        this.update();
    }

    public boolean getAdjustToVisibleData() {
        return this.m_AdjustToVisibleData;
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelZoomOverview.setVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelZoomOverview.isVisible();
    }

    protected boolean canPaint(Graphics g) {
        return this.getPlot() != null && this.m_Manager != null;
    }

    public void prepareUpdate() {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < ((TimeseriesContainerManager)this.getContainerManager()).count(); ++i) {
            List points;
            if (this.m_AdjustToVisibleData && !((TimeseriesContainerManager)this.getContainerManager()).isVisible(i) || (points = ((TimeseriesContainer)((TimeseriesContainerManager)this.getContainerManager()).get(i)).getData().toList()).size() == 0) continue;
            minX = Math.min(minX, (double)((TimeseriesPoint)((Object)points.get(0))).getTimestamp().getTime());
            maxX = Math.max(maxX, (double)((TimeseriesPoint)((Object)points.get(points.size() - 1))).getTimestamp().getTime());
            for (TimeseriesPoint point : points) {
                maxY = Math.max(maxY, point.getValue());
                minY = Math.min(minY, point.getValue());
            }
        }
        if (minX == maxX) {
            minX -= 1.0;
            maxX += 1.0;
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
    }

    public JPopupMenu getContainerListPopupMenu(final ContainerTable<M, C> table, final int row) {
        JPopupMenu result = new JPopupMenu();
        final int[] indices = table.getSelectedRows().length == 0 ? new int[]{row} : table.getSelectedRows();
        JMenuItem item = new JMenuItem("Toggle visibility");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TIntArrayList visible = new TIntArrayList();
                TIntArrayList invisible = new TIntArrayList();
                for (int i = 0; i < indices.length; ++i) {
                    int index = indices[i];
                    if (((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(index)).isVisible()) {
                        invisible.add(index);
                        continue;
                    }
                    visible.add(index);
                }
                Range range = new Range();
                range.setMax(((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).count());
                if (invisible.size() > 0) {
                    range.setIndices(invisible.toArray());
                    TimeseriesPanel.this.getScriptingEngine().add((BasePanel)TimeseriesPanel.this, "invisible " + range.getRange());
                }
                if (visible.size() > 0) {
                    range.setIndices(visible.toArray());
                    TimeseriesPanel.this.getScriptingEngine().add((BasePanel)TimeseriesPanel.this, "visible " + range.getRange());
                }
            }
        });
        result.add(item);
        item = new JMenuItem("Choose color...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = null;
                c = indices.length == 1 ? JColorChooser.showDialog((Component)table, "Choose color for " + ((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(indices[0])).getData().getID(), ((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(indices[0])).getColor()) : JColorChooser.showDialog((Component)table, "Choose color", ((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(row)).getColor());
                if (c != null) {
                    for (int index : indices) {
                        ((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(index)).setColor(c);
                    }
                }
            }
        });
        result.add(item);
        if (((TimeseriesContainerManager)this.getContainerManager()).getAllowRemoval()) {
            result.addSeparator();
            item = new JMenuItem("Remove");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesPanel.this.m_TimeseriesContainerList.getTable().removeContainers(indices);
                }
            });
            result.add(item);
            item = new JMenuItem("Remove all");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimeseriesPanel.this.m_TimeseriesContainerList.getTable().removeAllContainers();
                }
            });
            result.add(item);
        }
        result.addSeparator();
        item = new JMenuItem("Information");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<InformativeStatistic> stats = new ArrayList<InformativeStatistic>();
                for (int i = 0; i < indices.length; ++i) {
                    stats.add((InformativeStatistic)((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(indices[i])).getData().toStatistic());
                }
                TimeseriesPanel.this.showStatistics(stats);
            }
        });
        result.add(item);
        item = new JMenuItem("Raw data");
        item.setEnabled(indices.length == 1);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeseriesPanel.this.showRawData((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(row));
            }
        });
        result.add(item);
        item = new JMenuItem("Reports");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<TimeseriesContainer> data = new ArrayList<TimeseriesContainer>();
                for (int i = 0; i < indices.length; ++i) {
                    data.add((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(indices[i]));
                }
                TimeseriesPanel.this.showReports(data);
            }
        });
        result.add(item);
        item = new JMenuItem("Notes");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<TimeseriesContainer> data = new ArrayList<TimeseriesContainer>();
                for (int i = 0; i < indices.length; ++i) {
                    data.add((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(indices[i]));
                }
                TimeseriesPanel.this.showNotes(data);
            }
        });
        result.add(item);
        return result;
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        menu.addSeparator();
        JMenuItem item = new JMenuItem();
        if (!this.getTimeseriesPaintlet().isMarkersDisabled()) {
            item.setText("Disable markers");
        } else {
            item.setText("Enable markers");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeseriesPanel.this.getTimeseriesPaintlet().setMarkersDisabled(!TimeseriesPanel.this.getTimeseriesPaintlet().isMarkersDisabled());
                TimeseriesPanel.this.repaint();
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.isSidePanelVisible()) {
            item.setText("Hide side panel");
        } else {
            item.setText("Show side panel");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeseriesPanel.this.setSidePanelVisible(!TimeseriesPanel.this.isSidePanelVisible());
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.getAdjustToVisibleData()) {
            item.setText("Adjust to loaded data");
        } else {
            item.setText("Adjust to visible data");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeseriesPanel.this.setAdjustToVisibleData(!TimeseriesPanel.this.getAdjustToVisibleData());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Series statistics");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<InformativeStatistic> stats = new ArrayList<InformativeStatistic>();
                for (int i = 0; i < ((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).count(); ++i) {
                    if (!((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).isVisible(i)) continue;
                    stats.add((InformativeStatistic)((TimeseriesContainer)((TimeseriesContainerManager)TimeseriesPanel.this.getContainerManager()).get(i)).getData().toStatistic());
                }
                TimeseriesPanel.this.showStatistics(stats);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save visible series...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeseriesPanel.this.saveVisibleSeries();
            }
        });
        menu.add(item);
        SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JPopupMenu)menu);
    }

    protected void showNotes(List<TimeseriesContainer> data) {
        NotesFactory.Dialog dialog = this.getParentDialog() != null ? NotesFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : NotesFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        dialog.setData(data);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    protected void showStatistics(List<InformativeStatistic> stats) {
        InformativeStatisticFactory.Dialog dialog = this.getParentDialog() != null ? InformativeStatisticFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : InformativeStatisticFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        dialog.setStatistics(stats);
        dialog.setVisible(true);
    }

    protected void showRawData(TimeseriesContainer cont) {
        SpreadSheetDialog dialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(this.getParentFrame(), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Timeseries");
        dialog.setSize(600, 600);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setSpreadSheet(cont.getData().toSpreadSheet());
        dialog.setNumDecimals(this.getProperties().getInteger("SpreadSheetPanel.NumDecimals", Integer.valueOf(3)).intValue());
        dialog.setVisible(true);
    }

    protected void showReports(List<TimeseriesContainer> data) {
        ReportFactory.Dialog dialog = this.getParentDialog() != null ? ReportFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : ReportFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        ArrayList<ReportContainer> conts = new ArrayList<ReportContainer>();
        for (TimeseriesContainer c : data) {
            ReportContainer rc = c.getData().hasReport() ? new ReportContainer(null, (ReportHandler)c.getData()) : new ReportContainer(null, new Report());
            conts.add(rc);
        }
        dialog.setData(conts);
        dialog.setReportContainerListWidth((int)this.getSidePanel().getPreferredSize().getWidth());
        dialog.setVisible(true);
    }

    public int[] getSelectedIndices() {
        return this.m_TimeseriesContainerList.getTable().getSelectedRows();
    }

    public Timeseries[] getSelectedSpectra() {
        int[] indices = this.getSelectedIndices();
        Timeseries[] result = new Timeseries[indices.length];
        TimeseriesContainerManager manager = (TimeseriesContainerManager)this.getContainerManager();
        for (int i = 0; i < indices.length; ++i) {
            result[i] = ((TimeseriesContainer)manager.get(i)).getData();
        }
        return result;
    }

    public TimeseriesContainerList getTimeseriesContainerList() {
        return this.m_TimeseriesContainerList;
    }

    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton((AbstractDatabaseConnection)this.getDatabaseConnection());
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_TimeseriesPaintlet.setAntiAliasingEnabled(value);
        if (this.m_PanelZoomOverview.getContainerPaintlet() instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)this.m_PanelZoomOverview.getContainerPaintlet()).setAntiAliasingEnabled(value);
        }
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_TimeseriesPaintlet.isAntiAliasingEnabled();
    }

    protected void postUpdate() {
        super.postUpdate();
        if (this.m_PanelZoomOverview != null) {
            this.m_PanelZoomOverview.update();
        }
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String result = tiptext;
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        String hit = (String)this.m_TimeseriesPointHitDetector.detect(event);
        if (hit != null) {
            result = result + hit;
        }
        result = GUIHelper.processTipText((String)result, (int)this.m_ToolTipMaxColumns);
        return result;
    }

    protected void saveVisibleSeries() {
        block5: {
            String[] ext;
            AbstractTimeseriesWriter writer;
            block4: {
                if (this.m_ExportDialog == null) {
                    this.m_ExportDialog = this.getParentDialog() != null ? new TimeseriesExportDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new TimeseriesExportDialog(this.getParentFrame(), true);
                }
                this.m_ExportDialog.setLocationRelativeTo((Component)((Object)this));
                this.m_ExportDialog.setVisible(true);
                if (this.m_ExportDialog.getOption() != 0) {
                    return;
                }
                writer = (AbstractTimeseriesWriter)((Object)this.m_ExportDialog.getExport());
                ext = writer instanceof MetaFileWriter ? ((MetaFileWriter)writer).getActualFormatExtensions() : writer.getFormatExtensions();
                if (!writer.canWriteMultiple() || !this.m_ExportDialog.getCombine()) break block4;
                String filename = ((TimeseriesContainerManager)this.getContainerManager()).getVisible(0).getDisplayID() + "_and_" + (((TimeseriesContainerManager)this.getContainerManager()).countVisible() - 1) + "_more";
                filename = FileUtils.createFilename((String)filename, (String)"");
                filename = this.m_ExportDialog.getDirectory().getAbsolutePath() + File.separator + filename + "." + ext[0];
                writer.setOutput(new PlaceholderFile(filename));
                ArrayList<Timeseries> data = new ArrayList<Timeseries>();
                for (int i = 0; i < ((TimeseriesContainerManager)this.getContainerManager()).countVisible(); ++i) {
                    AbstractContainer cont = ((TimeseriesContainerManager)this.getContainerManager()).getVisible(i);
                    data.add(cont.getData());
                }
                if (writer.write(data)) break block5;
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write timeseries data to '" + filename + "'!"));
                break block5;
            }
            String prefix = this.m_ExportDialog.getDirectory().getAbsolutePath();
            for (int i = 0; i < ((TimeseriesContainerManager)this.getContainerManager()).countVisible(); ++i) {
                AbstractContainer cont = ((TimeseriesContainerManager)this.getContainerManager()).getVisible(i);
                String filename = prefix + File.separator + FileUtils.createFilename((String)cont.getDisplayID(), (String)"") + "." + ext[0];
                writer.setOutput(new PlaceholderFile(filename));
                if (writer.write((DataContainer)cont.getData())) continue;
                GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write timeseries #" + (i + 1) + " to '" + filename + "'!"));
                break;
            }
        }
    }

    public void cleanUp() {
        this.m_TimeseriesContainerList.cleanUp();
        if (this.m_ExportDialog != null) {
            this.m_ExportDialog.dispose();
            this.m_ExportDialog = null;
        }
        super.cleanUp();
    }
}

