/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Properties;
import adams.core.Utils;
import adams.data.container.DataPoint;
import adams.data.io.input.AbstractTimeseriesReader;
import adams.data.report.Report;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;

public class SimpleTimeseriesReader
extends AbstractTimeseriesReader {
    private static final long serialVersionUID = 1598168889943642045L;
    public static final String FILE_FORMAT = "sts";
    public static final String FILE_FORMAT_GZ = "sts.gz";

    public String globalInfo() {
        return "Reader for the simple timeseries format.";
    }

    public String getFormatDescription() {
        return "Simple timeseries";
    }

    public String[] getFormatExtensions() {
        return new String[]{FILE_FORMAT, FILE_FORMAT_GZ};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readData() {
        BufferedReader reader = null;
        DateFormat dformat = DateUtils.getTimestampFormatterMsecs();
        Timeseries series = new Timeseries();
        try {
            Report sd;
            String line;
            reader = this.m_Input.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.m_Input.getAbsolutePath())))) : new BufferedReader(new FileReader(this.m_Input.getAbsolutePath()));
            ArrayList<String> content = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                content.add(line);
            }
            ArrayList report = new ArrayList();
            while (content.size() > 0 && ((String)content.get(0)).startsWith("# ")) {
                report.add(content.get(0));
                content.remove(0);
            }
            if (report.size() > 0 && (sd = Report.parseProperties((Properties)Properties.fromComment((String)Utils.flatten(report, (String)"\n")))) != null) {
                series.setID(sd.getStringValue("ID"));
                series.setReport(sd);
            }
            content.remove(0);
            while (content.size() > 0) {
                line = ((String)content.get(0)).trim();
                content.remove(0);
                if (line.length() == 0) continue;
                String[] parts = line.split(",");
                TimeseriesPoint point = new TimeseriesPoint(dformat.parse(Utils.unDoubleQuote((String)parts[0])), Double.parseDouble(parts[1]));
                series.add((DataPoint)point);
            }
            this.m_ReadData.add(series);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read timeseries: " + this.m_Input, e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }
}

