/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.data.container.DataContainerUtils;
import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesPointComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class TimeseriesUtils
extends DataContainerUtils {
    protected static TimeseriesPointComparator m_Comparator = new TimeseriesPointComparator(true);

    public static TimeseriesPointComparator getComparator() {
        return m_Comparator;
    }

    protected static Timeseries getHeader(List<TimeseriesPoint> points) {
        Timeseries result;
        if (points.size() > 0 && points.get(0).getParent() != null) {
            result = ((Timeseries)points.get(0).getParent()).getHeader();
        } else {
            result = new Timeseries();
            result.setID("unknown");
        }
        return result;
    }

    public static int findTimestamp(List<TimeseriesPoint> points, TimeseriesPoint p) {
        int result = Collections.binarySearch(points, p, m_Comparator);
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    public static int findTimestamp(List<TimeseriesPoint> points, Date timestamp) {
        return TimeseriesUtils.findTimestamp(points, new TimeseriesPoint(timestamp, 0.0));
    }

    public static int findClosestTimestamp(List<TimeseriesPoint> points, Date timestamp) {
        int result = -1;
        if (points.size() == 0) {
            return result;
        }
        int index = Collections.binarySearch(points, new TimeseriesPoint(timestamp, 0.0), m_Comparator);
        if (index < 0) {
            if ((index = -index) >= points.size()) {
                index = points.size() - 1;
            }
            result = index;
            double dist = Math.abs(timestamp.getTime() - points.get(index).getTimestamp().getTime());
            for (int i = index - 2; i <= index + 2; ++i) {
                if (i < 0 || i >= points.size()) continue;
                TimeseriesPoint currPoint = points.get(i);
                double currDist = Math.abs(timestamp.getTime() - currPoint.getTimestamp().getTime());
                if (!(currDist < dist)) continue;
                dist = currDist;
                result = i;
            }
        } else {
            result = index;
        }
        return result;
    }

    public static int[] findEnclosingTimestamps(List<TimeseriesPoint> points, Date timestamp) {
        int[] result = new int[]{-1, -1};
        int index = TimeseriesUtils.findClosestTimestamp(points, timestamp);
        if (index > -1) {
            if (points.get(index).getTimestamp().getTime() <= timestamp.getTime()) {
                result[0] = index;
                if (index < points.size() - 1) {
                    result[1] = index + 1;
                }
            } else if (points.get(index).getTimestamp().getTime() > timestamp.getTime()) {
                result[1] = index;
                if (index > 0) {
                    result[0] = index - 1;
                }
            }
        }
        return result;
    }

    public static Timeseries union(Timeseries a, Timeseries b) {
        Timeseries result = (Timeseries)((Object)a.getClone());
        List points = b.toList();
        for (int i = 0; i < points.size(); ++i) {
            if (a.find(((TimeseriesPoint)((Object)points.get(i))).getTimestamp()) != null) continue;
            result.add((DataPoint)((TimeseriesPoint)((Object)((TimeseriesPoint)((Object)points.get(i))).getClone())));
        }
        return result;
    }

    public static Timeseries minus(Timeseries a, Timeseries b) {
        Timeseries result = a.getHeader();
        List points = a.toList();
        for (int i = 0; i < points.size(); ++i) {
            if (b.find(((TimeseriesPoint)((Object)points.get(i))).getTimestamp()) != null) continue;
            result.add((DataPoint)((TimeseriesPoint)((Object)((TimeseriesPoint)((Object)points.get(i))).getClone())));
        }
        return result;
    }

    public static Timeseries intersect(Timeseries a, Timeseries b) {
        Timeseries result = a.getHeader();
        List points = a.toList();
        for (int i = 0; i < points.size(); ++i) {
            if (b.find(((TimeseriesPoint)((Object)points.get(i))).getTimestamp()) == null) continue;
            result.add((DataPoint)((TimeseriesPoint)((Object)((TimeseriesPoint)((Object)points.get(i))).getClone())));
        }
        return result;
    }

    protected static void add(Hashtable<Date, TimeseriesPoint> pool, Timeseries s) {
        for (TimeseriesPoint pointSP : s.toList()) {
            TimeseriesPoint poolSP = pool.get(pointSP.getTimestamp());
            if (poolSP == null) {
                poolSP = pointSP;
            }
            pool.put(poolSP.getTimestamp(), poolSP);
        }
    }

    public static Timeseries merge(Timeseries s1, Timeseries s2) {
        ArrayList<Timeseries> list = new ArrayList<Timeseries>();
        list.add(s1);
        list.add(s2);
        return TimeseriesUtils.merge(list);
    }

    public static Timeseries merge(List<Timeseries> list) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Timeseries result = list.get(0).getHeader();
        Hashtable<Date, TimeseriesPoint> pool = new Hashtable<Date, TimeseriesPoint>();
        for (int i = 0; i < list.size(); ++i) {
            TimeseriesUtils.add(pool, list.get(i));
        }
        Enumeration elements = pool.elements();
        while (elements.hasMoreElements()) {
            result.add((DataPoint)elements.nextElement());
        }
        return result;
    }

    public static double[] toDoubleArray(Timeseries c) {
        return TimeseriesUtils.toDoubleArray(c.toList());
    }

    public static double[] toDoubleArray(List<TimeseriesPoint> data) {
        double[] result = new double[data.size()];
        int i = 0;
        for (TimeseriesPoint gcp : data) {
            result[i++] = new Double(gcp.getValue());
        }
        return result;
    }
}

