/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.data.baseline.AbstractSavitzkyGolayBased;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractSavitzkyGolay;
import adams.data.filter.SavitzkyGolay;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;

public class SavitzkyGolayBased
extends AbstractSavitzkyGolayBased<Timeseries> {
    private static final long serialVersionUID = -2273739395862247537L;

    protected AbstractSavitzkyGolay getFilter() {
        SavitzkyGolay result = new SavitzkyGolay();
        result.setDerivativeOrder(0);
        return result;
    }

    protected DataPoint getOriginalPoint(DataPoint newPoint, Timeseries original) {
        int index = TimeseriesUtils.findClosestTimestamp(original.toList(), ((TimeseriesPoint)newPoint).getTimestamp());
        if (index < 0) {
            return null;
        }
        return (DataPoint)original.toList().get(index);
    }

    protected DataPoint subtract(DataPoint old, DataPoint baseline) {
        TimeseriesPoint oldP = (TimeseriesPoint)old;
        TimeseriesPoint baseP = (TimeseriesPoint)baseline;
        TimeseriesPoint result = new TimeseriesPoint(oldP.getTimestamp(), oldP.getValue() - baseP.getValue());
        return result;
    }
}

