/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.timeseries.Timeseries;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.transformer.AbstractTransformer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class TimeseriesReportDbReader
extends AbstractTransformer {
    private static final long serialVersionUID = 1429977151568224156L;
    public static final String PLACEHOLDER_ID = "{ID}";
    protected SQLStatement m_SQL;
    protected QueryType m_QueryType;
    protected String m_ColumnKey;
    protected String m_ColumnValue;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public String globalInfo() {
        return "Adds all the data to the report of the timeseries passing through that the SQL statement returns.\nThe {ID} placeholder can be used in the SQL statement to represent the current timeseries' ID.\nThe following types of SQL statements are supported:\n- multiple rows of key-value pairs.\n- single row, with the key being the column name.\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", (Object)new SQLStatement("select key,value from table where id = \"{ID}\""));
        this.m_OptionManager.add("query-type", "queryType", (Object)QueryType.KEY_VALUE);
        this.m_OptionManager.add("column-key", "columnKey", (Object)"key");
        this.m_OptionManager.add("column-value", "columnValue", (Object)"value");
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement that selects the key-value pairs for the timeseries report; you can use the {ID} placeholder for the current timeseries' ID in your SQL statement.";
    }

    public void setQueryType(QueryType value) {
        this.m_QueryType = value;
        this.reset();
    }

    public QueryType getQueryType() {
        return this.m_QueryType;
    }

    public String queryTypeTipText() {
        return "The type of query that the SQL statement represents; multiple rows with key-value pairs (" + (Object)((Object)QueryType.KEY_VALUE) + ") or single row " + "with the column name as key (" + (Object)((Object)QueryType.COLUMN_AS_KEY) + ").";
    }

    public void setColumnKey(String value) {
        this.m_ColumnKey = value;
        this.reset();
    }

    public String getColumnKey() {
        return this.m_ColumnKey;
    }

    public String columnKeyTipText() {
        return "The name of the column containing the key for the key-value pairs to be added to the timeseries report.";
    }

    public void setColumnValue(String value) {
        this.m_ColumnValue = value;
        this.reset();
    }

    public String getColumnValue() {
        return this.m_ColumnValue;
    }

    public String columnValueTipText() {
        return "The name of the column containing the value for the key-value pairs to be added to the timeseries report.";
    }

    public Class[] accepts() {
        return new Class[]{Timeseries.class};
    }

    public Class[] generates() {
        return new Class[]{Timeseries.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"queryType", (Object)((Object)this.m_QueryType), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"SQL", (Object)Utils.shorten((String)this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), (int)50), (String)", query: ");
        return result;
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((AbstractActor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                result = "No database connection available!";
            }
        }
        return result;
    }

    protected void addToReport(Report report, String key, Object value) {
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("key: " + key);
            this.getLogger().fine("value: " + value);
        }
        if (value == null) {
            return;
        }
        String str = value.toString();
        if (Utils.isDouble((String)str)) {
            report.addField((AbstractField)new Field(key, DataType.NUMERIC));
            report.setNumericValue(key, Double.parseDouble(str));
        } else if (Utils.isBoolean((String)str)) {
            report.addField((AbstractField)new Field(key, DataType.BOOLEAN));
            report.setBooleanValue(key, Boolean.parseBoolean(str.toLowerCase()));
        } else {
            report.addField((AbstractField)new Field(key, DataType.STRING));
            report.setStringValue(key, str);
        }
    }

    protected String doExecute() {
        String result = null;
        Timeseries series = (Timeseries)((Object)this.m_InputToken.getPayload());
        if (!series.hasReport()) {
            series.setReport(new Report());
        }
        Object report = series.getReport();
        try {
            String query = this.m_SQL.getValue();
            query = query.replace(PLACEHOLDER_ID, series.getID());
            query = this.getVariables().expand(query);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("query: " + query);
            }
            ResultSet rs = SQL.getSingleton((AbstractDatabaseConnection)this.m_DatabaseConnection).getResultSet(query);
            boolean dataRead = false;
            switch (this.m_QueryType) {
                case KEY_VALUE: {
                    while (rs.next()) {
                        dataRead = true;
                        String key = rs.getObject(this.m_ColumnKey).toString();
                        Object value = rs.getObject(this.m_ColumnValue);
                        this.addToReport((Report)report, key, value);
                    }
                    break;
                }
                case COLUMN_AS_KEY: {
                    if (!rs.next()) break;
                    dataRead = true;
                    ResultSetMetaData meta = rs.getMetaData();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        if (meta.getColumnName(i).toLowerCase().equals(this.m_ColumnKey.toString())) continue;
                        String key = meta.getColumnName(i).toLowerCase();
                        Object value = rs.getObject(i);
                        this.addToReport((Report)report, key, value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled query type: " + (Object)((Object)this.m_QueryType));
                }
            }
            SQL.closeAll((ResultSet)rs);
            if (!dataRead) {
                result = "No data found for ID: " + series.getID();
            }
            this.m_OutputToken = new Token((Object)series);
        }
        catch (Exception e) {
            result = this.handleException("Failed to read timeseries report data for ID: " + series.getID(), e);
        }
        return result;
    }

    public static enum QueryType {
        KEY_VALUE,
        COLUMN_AS_KEY;

    }
}

