/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.source.wekaforecastersetup.AbstractForecasterGenerator;
import adams.flow.source.wekaforecastersetup.WekaForecasterGenerator;
import weka.classifiers.timeseries.AbstractForecaster;

public class WekaForecasterSetup
extends AbstractSimpleSource {
    private static final long serialVersionUID = -3019442578354930841L;
    protected AbstractForecasterGenerator m_Generator;

    public String globalInfo() {
        return "Outputs a configured instance of a Weka Forecaster.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new WekaForecasterGenerator());
    }

    public void setGenerator(AbstractForecasterGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractForecasterGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The forecaster generator to use.";
    }

    public String getQuickInfo() {
        String result = this.m_Generator.getQuickInfo();
        result = result != null ? ((Object)((Object)this.m_Generator)).getClass().getSimpleName() + ": " + result : ((Object)((Object)this.m_Generator)).getClass().getSimpleName();
        return result;
    }

    public Class[] generates() {
        return new Class[]{AbstractForecaster.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            AbstractForecaster forecaster = this.m_Generator.generate();
            this.m_OutputToken = new Token((Object)forecaster);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to configure Forecaster:", e);
        }
        return result;
    }
}

