/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.DecimalFormatString;
import adams.data.timeseries.PeriodicityType;
import adams.data.timeseries.Timeseries;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.MergeableDisplayPanel;
import adams.gui.core.BasePanel;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.PeriodicityTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.DefaultTimeseriesXAxisPanelOptions;
import adams.gui.visualization.timeseries.DefaultTimeseriesYAxisPanelOptions;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesExplorer;
import adams.gui.visualization.timeseries.TimeseriesXAxisPanelOptions;
import adams.gui.visualization.timeseries.TimeseriesYAxisPanelOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;

public class TimeseriesDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 2505818295695863125L;
    protected TimeseriesXAxisPanelOptions m_AxisX;
    protected TimeseriesYAxisPanelOptions m_AxisY;
    protected AbstractColorProvider m_ColorProvider;
    protected boolean m_ShowSidePanel;
    protected boolean m_ZoomOverview;
    protected Paintlet[] m_Overlays;

    public String globalInfo() {
        return "Actor that displays timeseries.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("axis-x", "axisX", (Object)this.getDefaultAxisX());
        this.m_OptionManager.add("axis-y", "axisY", (Object)this.getDefaultAxisY());
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("show-side-panel", "showSidePanel", (Object)true);
        this.m_OptionManager.add("zoom-overview", "zoomOverview", (Object)false);
        this.m_OptionManager.add("overlay", "overlays", (Object)new Paintlet[0]);
    }

    protected int getDefaultWidth() {
        return 1000;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    protected TimeseriesXAxisPanelOptions getDefaultAxisX() {
        DefaultTimeseriesXAxisPanelOptions result = new DefaultTimeseriesXAxisPanelOptions();
        result.setType(Type.DATE);
        result.setLabel("time");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setWidth(40);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        PeriodicityTickGenerator tick = new PeriodicityTickGenerator();
        tick.setPeriodicity(PeriodicityType.NONE);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    protected TimeseriesYAxisPanelOptions getDefaultAxisY() {
        DefaultTimeseriesYAxisPanelOptions result = new DefaultTimeseriesYAxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("value");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(2);
        result.setWidth(60);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        result.setCustomFormat(new DecimalFormatString("0.0"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(10);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    public void setAxisX(TimeseriesXAxisPanelOptions value) {
        this.m_AxisX = value;
        this.reset();
    }

    public TimeseriesXAxisPanelOptions getAxisX() {
        return this.m_AxisX;
    }

    public String axisXTipText() {
        return "The setup for the X axis.";
    }

    public void setAxisY(TimeseriesYAxisPanelOptions value) {
        this.m_AxisY = value;
        this.reset();
    }

    public TimeseriesYAxisPanelOptions getAxisY() {
        return this.m_AxisY;
    }

    public String axisYTipText() {
        return "The setup for the Y axis.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for generating the colors for the various plots.";
    }

    public void setShowSidePanel(boolean value) {
        this.m_ShowSidePanel = value;
        this.reset();
    }

    public boolean getShowSidePanel() {
        return this.m_ShowSidePanel;
    }

    public String showSidePanelTipText() {
        return "If enabled, the side panel with the list of loaded spectra gets displayed.";
    }

    public void setZoomOverview(boolean value) {
        this.m_ZoomOverview = value;
        this.reset();
    }

    public boolean getZoomOverview() {
        return this.m_ZoomOverview;
    }

    public String zoomOverviewTipText() {
        return "If enabled, a zoom overview panel gets displayed as well.";
    }

    public void setOverlays(Paintlet[] value) {
        this.m_Overlays = value;
        this.reset();
    }

    public Paintlet[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "The paintlets to use for overlays.";
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            ((TimeseriesExplorer)this.m_Panel).getContainerManager().clear();
        }
    }

    protected BasePanel newPanel() {
        TimeseriesExplorer result = new TimeseriesExplorer();
        result.getContainerManager().setAllowRemoval(false);
        result.getContainerManager().setReloadable(false);
        result.getContainerManager().setColorProvider(this.m_ColorProvider.shallowCopy());
        result.getTimeseriesPanel().setSidePanelVisible(this.m_ShowSidePanel);
        result.setZoomOverviewPanelVisible(this.m_ZoomOverview);
        this.m_AxisX.configure(result.getTimeseriesPanel().getPlot(), Axis.BOTTOM);
        this.m_AxisY.configure(result.getTimeseriesPanel().getPlot(), Axis.LEFT);
        for (Paintlet p : this.m_Overlays) {
            Paintlet overlay = (Paintlet)p.shallowCopy(true);
            overlay.setPanel((PaintablePanel)result.getTimeseriesPanel());
            result.getTimeseriesPanel().addPaintlet(overlay);
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Timeseries.class};
    }

    protected void display(Token token) {
        AbstractContainer cont = ((TimeseriesExplorer)this.m_Panel).getContainerManager().newContainer((Comparable)((Object)((Timeseries)((Object)token.getPayload()))));
        ((TimeseriesExplorer)this.m_Panel).getContainerManager().add(cont);
    }

    public DisplayPanel createDisplayPanel(Token token) {
        DisplayPanel result = new DisplayPanel(((Object)((Object)this)).getClass().getSimpleName());
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    protected class DisplayPanel
    extends AbstractComponentDisplayPanel
    implements MergeableDisplayPanel<DisplayPanel> {
        private static final long serialVersionUID = 7384093089760722339L;
        protected TimeseriesExplorer m_Panel;

        protected DisplayPanel(String name) {
            super(name);
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_Panel = new TimeseriesExplorer();
            this.m_Panel.getContainerManager().setAllowRemoval(false);
            this.m_Panel.getContainerManager().setReloadable(false);
            this.m_Panel.getContainerManager().setColorProvider(TimeseriesDisplay.this.m_ColorProvider.shallowCopy());
            this.m_Panel.getTimeseriesPanel().setSidePanelVisible(TimeseriesDisplay.this.m_ShowSidePanel);
            this.m_Panel.setZoomOverviewPanelVisible(TimeseriesDisplay.this.m_ZoomOverview);
            TimeseriesDisplay.this.m_AxisX.configure(this.m_Panel.getTimeseriesPanel().getPlot(), Axis.BOTTOM);
            TimeseriesDisplay.this.m_AxisY.configure(this.m_Panel.getTimeseriesPanel().getPlot(), Axis.LEFT);
            for (Paintlet p : TimeseriesDisplay.this.m_Overlays) {
                Paintlet overlay = (Paintlet)p.shallowCopy(true);
                overlay.setPanel((PaintablePanel)this.m_Panel.getTimeseriesPanel());
                this.m_Panel.getTimeseriesPanel().addPaintlet(overlay);
            }
            this.add((Component)((Object)this.m_Panel), "Center");
        }

        public void display(Token token) {
            Timeseries ts = (Timeseries)((Object)token.getPayload());
            AbstractContainer cont = this.m_Panel.getContainerManager().newContainer((Comparable)((Object)ts));
            this.m_Panel.getContainerManager().add(cont);
        }

        public void cleanUp() {
            this.m_Panel.getContainerManager().clear();
        }

        public void clearPanel() {
            this.m_Panel.getContainerManager().clear();
        }

        public JComponent supplyComponent() {
            return this.m_Panel;
        }

        public void mergeWith(DisplayPanel other) {
            this.m_Panel.getContainerManager().startUpdate();
            List list = other.m_Panel.getContainerManager().getAll();
            for (TimeseriesContainer cont : list) {
                cont.setColor(Color.WHITE);
                this.m_Panel.getContainerManager().add(cont);
            }
            this.m_Panel.getContainerManager().finishUpdate();
        }
    }
}

