/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;
import adams.flow.transformer.AbstractDataContainerAdd;
import java.util.List;

public class TimeseriesAdd
extends AbstractDataContainerAdd<Timeseries> {
    private static final long serialVersionUID = 2022407828928180169L;

    public String globalInfo() {
        return "Superimposes the incoming timeseries on the one in storage, i.e., adds up the values for existing timestamps, otherwise adding new timestamps.\nIf none yet available from storage, then the current one simply put into storage.";
    }

    public String storageNameTipText() {
        return "The name of the timeseries in internal storage.";
    }

    protected Class getDataContainerClass() {
        return Timeseries.class;
    }

    protected void add(Timeseries stored, Timeseries current) {
        for (Object o : current.toList()) {
            TimeseriesPoint addPoint = (TimeseriesPoint)((Object)((TimeseriesPoint)((Object)o)).getClone());
            int index = TimeseriesUtils.findTimestamp((List<TimeseriesPoint>)stored.toList(), addPoint.getTimestamp());
            if (index == -1) {
                stored.add((DataPoint)addPoint);
                continue;
            }
            TimeseriesPoint currPoint = (TimeseriesPoint)((Object)stored.toList().get(index));
            TimeseriesPoint newPoint = new TimeseriesPoint(currPoint.getTimestamp(), currPoint.getValue() + addPoint.getValue());
            stored.add((DataPoint)newPoint);
        }
    }
}

