/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.base.BaseDateTime;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.Date;
import java.util.List;

public class TimeseriesResetTimestamps
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = -1306518673446335794L;
    protected BaseDateTime m_Start;

    public String globalInfo() {
        return "Resets the timestamps, makes them start at the specified date/time. The relative time differences between the data points are kept.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", (Object)new BaseDateTime("-INF"));
    }

    public void setStart(BaseDateTime value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseDateTime getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The start date/time to reset the timestamps to.";
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        List points = data.toList();
        if (points.size() == 0) {
            return result;
        }
        long newStart = this.m_Start.dateValue().getTime();
        long oldStart = ((TimeseriesPoint)((Object)points.get(0))).getTimestamp().getTime();
        long diff = oldStart - newStart;
        for (TimeseriesPoint point : points) {
            result.add((DataPoint)new TimeseriesPoint(new Date(point.getTimestamp().getTime() - diff), point.getValue()));
        }
        return result;
    }
}

