/*
 * Decompiled with CFR 0.152.
 */
package adams.data.timeseries;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import adams.data.timeseries.AbstractMetaTimeseriesFeatureGenerator;
import adams.data.timeseries.AbstractTimeseriesFeatureGenerator;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.Values;
import java.util.List;

public class AddMetaData
extends AbstractMetaTimeseriesFeatureGenerator {
    private static final long serialVersionUID = 8819500364007702561L;
    protected boolean m_AddDatabaseID;
    protected boolean m_AddID;

    public String globalInfo() {
        return "Meta-generator that can add database ID and container ID.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("add-database-id", "addDatabaseID", (Object)false);
        this.m_OptionManager.add("add-id", "addID", (Object)false);
    }

    @Override
    protected AbstractTimeseriesFeatureGenerator getDefaultGenerator() {
        return new Values();
    }

    public void setAddDatabaseID(boolean value) {
        this.m_AddDatabaseID = value;
        this.reset();
    }

    public boolean getAddDatabaseID() {
        return this.m_AddDatabaseID;
    }

    public String addDatabaseIDTipText() {
        return "If enabled, the database ID of the container gets added to the data.";
    }

    public void setAddID(boolean value) {
        this.m_AddID = value;
        this.reset();
    }

    public boolean getAddID() {
        return this.m_AddID;
    }

    public String addIDTipText() {
        return "If enabled, the ID of the container gets added to the data.";
    }

    @Override
    public HeaderDefinition createHeader(Timeseries timeseries) {
        HeaderDefinition result = this.m_Generator.createHeader(timeseries);
        if (this.m_AddID) {
            result.add(0, "ID", DataType.STRING);
        }
        if (this.m_AddDatabaseID) {
            result.add(0, "DatabaseID", DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(Timeseries timeseries) {
        List<Object>[] result;
        for (List<Object> row : result = this.m_Generator.generateRows(timeseries)) {
            if (this.m_AddID) {
                row.add(0, timeseries.getID());
            }
            if (!this.m_AddDatabaseID) continue;
            row.add(0, timeseries.getDatabaseID());
        }
        return result;
    }
}

