/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.timeseriessplit;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.OptionHandler;
import adams.data.DateFormatString;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.timeseries.Timeseries;
import adams.flow.transformer.timeseriessplit.AbstractSplitOnDate;
import java.util.Date;

public class ReportDate
extends AbstractSplitOnDate
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 259240444289354690L;
    protected Field m_Field;
    protected String m_CustomFormat;

    public String globalInfo() {
        return "Splits the timeseries using a field from its report.\nAccepted date formats (unless custom format specified):\nyyyy-MM-dd HH:mm:ss\nyyyy-MM-dd HH:mm:ss.S\nyyyy-MM-dd\nFor more information, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return new DateFormat().getTechnicalInformation();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", (Object)new Field("somedate", DataType.STRING));
        this.m_OptionManager.add("custom-format", "customFormat", (Object)"");
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The report field to obtain the split date from.";
    }

    public void setCustomFormat(String value) {
        DateFormatString format = new DateFormatString();
        if (value.isEmpty() || format.isValid(value)) {
            this.m_CustomFormat = value;
            this.reset();
        } else {
            this.getLogger().warning("Invalid date format: " + value);
        }
    }

    public String getCustomFormat() {
        return this.m_CustomFormat;
    }

    public String customFormatTipText() {
        return "The custom date format to use for parsing the value from the report.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"field", (Object)this.m_Field, (String)", field: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"customFormat", (Object)(this.m_CustomFormat.isEmpty() ? "-default-" : this.m_CustomFormat), (String)", format: ");
        return result;
    }

    @Override
    protected void check(Timeseries series) {
        super.check(series);
        if (!series.hasReport()) {
            throw new IllegalStateException("No report available!");
        }
        if (!series.getReport().hasValue((AbstractField)this.m_Field)) {
            throw new IllegalStateException("Report field '" + this.m_Field + "' not available!");
        }
        String dateStr = series.getReport().getStringValue((AbstractField)this.m_Field);
        if (this.m_CustomFormat.isEmpty()) {
            DateFormat dfts = new DateFormat("yyyy-MM-dd HH:mm:ss");
            DateFormat dftsm = new DateFormat("yyyy-MM-dd HH:mm:ss.S");
            DateFormat dfd = new DateFormat("yyyy-MM-dd");
            if (dfts.parse(dateStr) == null && dftsm.parse(dateStr) == null && dfd.parse(dateStr) == null) {
                throw new IllegalStateException("Report field '" + this.m_Field + "' is not parseable using formats " + "'" + "yyyy-MM-dd HH:mm:ss" + "' or " + "'" + "yyyy-MM-dd HH:mm:ss.S" + "' or " + "'" + "yyyy-MM-dd" + "'!");
            }
        }
    }

    @Override
    protected Timeseries[] doSplit(Timeseries series) {
        Date date = null;
        String dateStr = series.getReport().getStringValue((AbstractField)this.m_Field);
        if (this.m_CustomFormat.isEmpty()) {
            DateFormat dfts = new DateFormat("yyyy-MM-dd HH:mm:ss");
            DateFormat dftsm = new DateFormat("yyyy-MM-dd HH:mm:ss.S");
            DateFormat dfd = new DateFormat("yyyy-MM-dd");
            if (dfts.parse(dateStr) != null) {
                date = dfts.parse(dateStr);
            } else if (dftsm.parse(dateStr) != null) {
                date = dftsm.parse(dateStr);
            } else if (dfd.parse(dateStr) != null) {
                date = dfd.parse(dateStr);
            }
        } else {
            date = new DateFormat(this.m_CustomFormat).parse(dateStr);
        }
        return this.doSplit(series, date);
    }
}

