/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.base.BaseDateTime;
import adams.flow.core.Actor;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.FlowAwarePaintlet;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import adams.gui.visualization.timeseries.TimeseriesPaintlet;
import java.awt.Graphics;

public class PaintletWithFixedXRange
extends AbstractTimeseriesPaintlet
implements adams.gui.visualization.core.PaintletWithFixedXRange,
FlowAwarePaintlet {
    private static final long serialVersionUID = 3270329510617886683L;
    protected BaseDateTime m_MinX;
    protected BaseDateTime m_MaxX;
    protected AbstractTimeseriesPaintlet m_Paintlet;
    protected Actor m_Actor;

    public String globalInfo() {
        return "Meta-paintlet that uses a fixed X range (for faster drawing) and a base-paintlet to draw the actual data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-x", "minX", (Object)new BaseDateTime("-INF"));
        this.m_OptionManager.add("max-x", "maxX", (Object)new BaseDateTime("+INF"));
        this.m_OptionManager.add("paintlet", "paintlet", (Object)this.getDefaultPaintlet());
    }

    protected void initialize() {
        this.setPaintlet(this.getDefaultPaintlet());
        super.initialize();
    }

    protected AbstractTimeseriesPaintlet getDefaultPaintlet() {
        return new TimeseriesPaintlet();
    }

    public void setPanel(PaintablePanel value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(value);
        }
        super.setPanel(value);
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        if (this.m_Paintlet != null) {
            return this.m_Paintlet.getPaintMoment();
        }
        return PaintEvent.PaintMoment.PAINT;
    }

    public void setMinX(BaseDateTime value) {
        this.m_MinX = value;
        this.memberChanged(true);
    }

    public BaseDateTime getMinX() {
        return this.m_MinX;
    }

    public double getMinimumX() {
        return this.m_MinX.dateValue().getTime();
    }

    public String minXTipText() {
        return "The minimum value for the X range.";
    }

    public void setMaxX(BaseDateTime value) {
        this.m_MaxX = value;
        this.memberChanged(true);
    }

    public BaseDateTime getMaxX() {
        return this.m_MaxX;
    }

    public double getMaximumX() {
        return this.m_MaxX.dateValue().getTime();
    }

    public String maxXTipText() {
        return "The maximum value for the X range.";
    }

    public void setPaintlet(AbstractTimeseriesPaintlet value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(null);
        }
        this.m_Paintlet = value;
        this.m_Paintlet.setPanel(this.getPanel());
        this.memberChanged();
    }

    public AbstractTimeseriesPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The actual paintlet to use for drawing the data.";
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        this.m_Paintlet.performPaint(g, moment);
    }

    public void setActor(Actor actor) {
        this.m_Actor = actor;
    }

    public Actor getActor() {
        return this.m_Actor;
    }
}

