/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToTimeseries;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetToTimeseriesTest
extends AbstractConversionTestCase {
    public SpreadSheetToTimeseriesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("wine.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("wine.csv");
        super.tearDown();
    }

    protected String toString(Object data) {
        Timeseries series = (Timeseries)data;
        StringBuilder result = new StringBuilder();
        for (Object obj : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)obj;
            result.append(point.toString());
            result.append("\n");
        }
        return result.toString();
    }

    protected Object[] getRegressionInput() {
        Object[] result = new SpreadSheet[1];
        try {
            result[0] = new CsvSpreadSheetReader().read((File)new TmpFile("wine.csv"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetToTimeseries[] result = new SpreadSheetToTimeseries[2];
        result[0] = new SpreadSheetToTimeseries();
        result[0].setDateColumn(new SpreadSheetColumnIndex("last"));
        result[0].setValueColumn(new SpreadSheetColumnIndex("first"));
        result[1] = new SpreadSheetToTimeseries();
        result[1].setDateColumn(new SpreadSheetColumnIndex("last"));
        result[1].setValueColumn(new SpreadSheetColumnIndex("Dry-white"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetToTimeseriesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetToTimeseriesTest.runTest((Test)SpreadSheetToTimeseriesTest.suite());
    }
}

