/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.WekaForecaster;

public class WekaForecastContainer
extends AbstractContainer {
    private static final long serialVersionUID = 872330681430825295L;
    public static final String VALUE_MODEL = "Model";
    public static final String VALUE_FORECASTS = "Forecasts";

    public WekaForecastContainer() {
        this((AbstractForecaster)new WekaForecaster(), new ArrayList<List<NumericPrediction>>());
    }

    public WekaForecastContainer(AbstractForecaster model, List<List<NumericPrediction>> forecasts) {
        this.store(VALUE_MODEL, model);
        this.store(VALUE_FORECASTS, forecasts);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_MODEL, "forecaster model; " + AbstractForecaster.class.getName());
        this.addHelp(VALUE_FORECASTS, "forecasts made; list of list of " + NumericPrediction.class.getName());
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_MODEL);
        result.add(VALUE_FORECASTS);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_MODEL) && this.hasValue(VALUE_FORECASTS);
    }
}

