/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.AbstractDistanceBasedHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerModel;
import adams.gui.visualization.timeseries.TimeseriesPanel;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeseriesPointHitDetector
extends AbstractDistanceBasedHitDetector {
    private static final long serialVersionUID = 7459498872766468963L;
    protected TimeseriesPanel m_Owner;

    public TimeseriesPointHitDetector(TimeseriesPanel owner) {
        this.m_Owner = owner;
    }

    public String globalInfo() {
        return "Detects selections of timeseries points in the timeseries panel.";
    }

    public TimeseriesPanel getOwner() {
        return this.m_Owner;
    }

    protected Object isHit(MouseEvent e) {
        ArrayList<TimeseriesPoint> result = new ArrayList<TimeseriesPoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double val = axisLeft.posToValue(e.getY());
        long time = (long)axisBottom.posToValue(e.getX());
        TimeseriesContainerModel model = (TimeseriesContainerModel)this.m_Owner.getContainerList().getContainerModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            TimeseriesPoint tp;
            if (!((TimeseriesContainer)model.getContainerAt(i)).isVisible()) continue;
            Timeseries s = ((TimeseriesContainer)model.getContainerAt(i)).getData();
            List points = s.toList();
            int[] indices = TimeseriesUtils.findEnclosingTimestamps(points, new Date(time));
            if (this.getDebug()) {
                this.getLogger().info("\n" + s.getID() + ":");
            }
            if (indices[0] == -1 || indices[1] == -1) {
                int index = TimeseriesUtils.findClosestTimestamp(points, new Date(time));
                if (index == -1) continue;
                tp = (TimeseriesPoint)((Object)points.get(index));
                double diffTime = tp.getTimestamp().getTime() - time;
                double diffPixel = Math.abs(axisBottom.valueToPos(diffTime) - axisBottom.valueToPos(0.0));
                if (this.getDebug()) {
                    this.getLogger().info("diff time=" + diffPixel);
                }
                if (diffPixel > (double)this.m_MinimumPixelDifference) continue;
                double diffTemp = tp.getValue() - val;
                diffPixel = Math.abs(axisLeft.valueToPos(diffTemp) - axisLeft.valueToPos(0.0));
                if (this.getDebug()) {
                    this.getLogger().info("diff val=" + diffPixel);
                }
                if (diffPixel > (double)this.m_MinimumPixelDifference) {
                    continue;
                }
            } else {
                tp = (TimeseriesPoint)((Object)points.get(indices[0]));
                TimeseriesPoint tp2 = (TimeseriesPoint)((Object)points.get(indices[1]));
                double dist = this.distance(new Point2D.Double(axisBottom.valueToPos((double)tp.getTimestamp().getTime()), axisLeft.valueToPos(tp.getValue())), new Point2D.Double(axisBottom.valueToPos((double)tp2.getTimestamp().getTime()), axisLeft.valueToPos(tp2.getValue())), new Point2D.Double(e.getX(), e.getY()));
                if (this.getDebug()) {
                    this.getLogger().info("dist line=" + dist);
                }
                if (dist > (double)this.m_MinimumPixelDifference) continue;
            }
            if (this.getDebug()) {
                this.getLogger().info("hit!");
            }
            result.add(tp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    protected Object processHit(MouseEvent e, Object hit) {
        List hits = (List)hit;
        String result = " (";
        for (int i = 0; i < hits.size(); ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            Timeseries tp = (Timeseries)((TimeseriesPoint)((Object)hits.get(i))).getParent();
            AbstractContainer cont = this.m_Owner.getContainerManager().newContainer((Comparable)((Object)tp));
            if (!(cont instanceof NamedContainer)) continue;
            result = result + ((NamedContainer)cont).getDisplayID();
        }
        result = result + ")";
        return result;
    }

    public void cleanUp() {
        this.m_Owner = null;
        super.cleanUp();
    }
}

