/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.List;

public class TimeseriesValueSubset
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected double m_Minimum;
    protected double m_Maximum;

    public String globalInfo() {
        return "Generates a new timeseries with the first block of values that fits between the specified min/max (both included).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)Double.MIN_VALUE);
        this.m_OptionManager.add("maximum", "maximum", (Object)Double.MAX_VALUE);
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum (included) that the values must satisfy.";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum (included) that the values must satisfy.";
    }

    protected void checkData(Timeseries data) {
        super.checkData((DataContainer)data);
        if (this.m_Minimum >= this.m_Maximum) {
            throw new IllegalStateException("Minimum must be smaller than maximum!");
        }
    }

    protected Timeseries processData(Timeseries data) {
        Timeseries result = data.getHeader();
        List points = data.toList();
        boolean adding = false;
        for (int i = 0; i < points.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)points.get(i));
            if (!(point.getValue() >= this.m_Minimum) || !(point.getValue() <= this.m_Maximum)) {
                if (!adding) continue;
                break;
            }
            adding = true;
            result.add((DataPoint)((TimeseriesPoint)((Object)point.getClone())));
        }
        return result;
    }
}

