/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateFormat;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.DateFormatString;
import adams.data.container.DataPoint;
import adams.data.io.input.AbstractTimeseriesReader;
import adams.data.report.Report;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;

public class SimpleTimeseriesReader
extends AbstractTimeseriesReader {
    private static final long serialVersionUID = 1598168889943642045L;
    public static final String FILE_FORMAT = "sts";
    public static final String FILE_FORMAT_GZ = "sts.gz";
    protected DateFormatString m_TimestampFormat;

    public String globalInfo() {
        return "Reader for the simple timeseries format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp-format", "timestampFormat", (Object)new DateFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public String getFormatDescription() {
        return "Simple timeseries";
    }

    public String[] getFormatExtensions() {
        return new String[]{FILE_FORMAT, FILE_FORMAT_GZ};
    }

    public void setTimestampFormat(DateFormatString value) {
        this.m_TimestampFormat = value;
        this.reset();
    }

    public DateFormatString getTimestampFormat() {
        return this.m_TimestampFormat;
    }

    public String timestampFormatTipText() {
        return "The format to use for the timestamps.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readData() {
        BufferedReader reader = null;
        FileReader fr = null;
        FileInputStream fis = null;
        DateFormat dformat = this.m_TimestampFormat.toDateFormat();
        Timeseries series = new Timeseries();
        try {
            Report sd;
            String line;
            if (this.m_Input.getName().endsWith(".gz")) {
                fis = new FileInputStream(this.m_Input.getAbsolutePath());
                reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(fis)));
            } else {
                fr = new FileReader(this.m_Input.getAbsolutePath());
                reader = new BufferedReader(fr);
            }
            ArrayList<String> content = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                content.add(line);
            }
            ArrayList report = new ArrayList();
            while (content.size() > 0 && ((String)content.get(0)).startsWith("# ")) {
                report.add(content.get(0));
                content.remove(0);
            }
            if (report.size() > 0 && (sd = Report.parseProperties((Properties)Properties.fromComment((String)Utils.flatten(report, (String)"\n")))) != null) {
                series.setID(sd.getStringValue("ID"));
                series.setReport(sd);
            }
            content.remove(0);
            while (content.size() > 0) {
                line = ((String)content.get(0)).trim();
                content.remove(0);
                if (line.length() == 0) continue;
                String[] parts = line.split(",");
                TimeseriesPoint point = new TimeseriesPoint(dformat.parse(Utils.unDoubleQuote((String)parts[0])), Double.parseDouble(parts[1]));
                series.add((DataPoint)point);
            }
            this.m_ReadData.add(series);
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read timeseries: " + this.m_Input, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(reader);
                FileUtils.closeQuietly(fr);
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)reader);
            FileUtils.closeQuietly((Reader)fr);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((Reader)reader);
        FileUtils.closeQuietly((Reader)fr);
        FileUtils.closeQuietly((InputStream)fis);
    }
}

