/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.transformer.AbstractTransformer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;

public class TimeseriesDbReader
extends AbstractTransformer {
    private static final long serialVersionUID = -1030024345072684197L;
    public static final String PLACEHOLDER_ID = "{ID}";
    protected SQLStatement m_SQL;
    protected String m_ColumnTimestamp;
    protected int m_ColumnTimestampType;
    protected int m_ColumnTimestampIndex;
    protected String m_ColumnValue;
    protected int m_ColumnValueType;
    protected int m_ColumnValueIndex;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public String globalInfo() {
        return "Outputs timeseries containers generated from an SQL SELECT statement.\nThe input is interpreted as the ID of the timeseries to load.\nThis ID can be used in the SQL statement using the {ID} placeholder.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", (Object)new SQLStatement("select timestamp,value from table where id = {ID} order by timestamp"));
        this.m_OptionManager.add("column-timestamp", "columnTimestamp", (Object)"");
        this.m_OptionManager.add("column-value", "columnValue", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = null;
    }

    protected void reset() {
        super.reset();
        this.m_ColumnTimestampType = 1111;
        this.m_ColumnTimestampIndex = -1;
        this.m_ColumnValueType = 1111;
        this.m_ColumnValueIndex = -1;
        this.m_DatabaseConnection = null;
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement that selects the timeseries data; use the {ID} placeholder in the statement to specify the ID of the timeseries to load.";
    }

    public void setColumnTimestamp(String value) {
        this.m_ColumnTimestamp = value;
        this.reset();
    }

    public String getColumnTimestamp() {
        return this.m_ColumnTimestamp;
    }

    public String columnTimestampTipText() {
        return "The name of the column containing the timestamp for a data point (accepted types: integer, date, time, datetime, timestamp); if left empty, the first date-like column from the SQL statement is used.";
    }

    public void setColumnValue(String value) {
        this.m_ColumnValue = value;
        this.reset();
    }

    public String getColumnValue() {
        return this.m_ColumnValue;
    }

    public String columnValueTipText() {
        return "The name of the column containing the value for a data point (accepted types: numeric); if left empty, the first numeric column from the SQL statement is used.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, Integer.class, Long.class};
    }

    public Class[] generates() {
        return new Class[]{Timeseries.class};
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"SQL", (Object)Shortening.shortenEnd((String)this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), (int)50));
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                result = "No database connection available!";
            }
        }
        return result;
    }

    protected TimeseriesPoint readDataPoint(ResultSet rs) throws Exception {
        Date timestamp;
        if (SQL.isInteger((int)this.m_ColumnTimestampIndex)) {
            timestamp = new Date(rs.getInt(this.m_ColumnTimestampIndex));
        } else if (this.m_ColumnTimestampType == 91) {
            timestamp = rs.getDate(this.m_ColumnTimestampIndex);
        } else if (this.m_ColumnTimestampType == 92) {
            timestamp = new Date(rs.getTime(this.m_ColumnTimestampIndex).getTime());
        } else if (this.m_ColumnTimestampType == 93) {
            timestamp = new Date(rs.getTimestamp(this.m_ColumnTimestampIndex).getTime());
        } else {
            throw new IllegalStateException("Unhandled column type: " + this.m_ColumnTimestampType);
        }
        double val = rs.getDouble(this.m_ColumnValueIndex);
        TimeseriesPoint result = new TimeseriesPoint(timestamp, val);
        return result;
    }

    protected Timeseries read(ResultSet rs) throws Exception {
        Timeseries result = new Timeseries();
        while (rs.next()) {
            TimeseriesPoint point = this.readDataPoint(rs);
            result.add((DataPoint)point);
        }
        return result;
    }

    protected void analyzeColumns(ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        this.m_ColumnTimestampType = 1111;
        this.m_ColumnTimestampIndex = -1;
        this.m_ColumnValueType = 1111;
        this.m_ColumnValueIndex = -1;
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            String col = meta.getColumnName(i);
            int type = meta.getColumnType(i);
            if (this.m_ColumnTimestampIndex == -1 && (this.m_ColumnTimestamp.isEmpty() && SQL.isDate((int)type) || col.toLowerCase().equals(this.m_ColumnTimestamp.toLowerCase()))) {
                this.m_ColumnTimestampIndex = i;
                this.m_ColumnTimestampType = type;
                continue;
            }
            if (this.m_ColumnValueIndex != -1 || (!this.m_ColumnValue.isEmpty() || !SQL.isNumeric((int)type)) && !col.toLowerCase().equals(this.m_ColumnValue.toLowerCase())) continue;
            this.m_ColumnValueIndex = i;
            this.m_ColumnValueType = type;
        }
        if (this.m_ColumnTimestampIndex == -1) {
            if (this.m_ColumnTimestamp.isEmpty()) {
                throw new IllegalStateException("No suitable 'timestamp' column found in result set!");
            }
            throw new IllegalStateException("Timestamp column '" + this.m_ColumnTimestamp + "' not found in result set!");
        }
        if (!SQL.isInteger((int)this.m_ColumnTimestampType) && this.m_ColumnTimestampType != 91 && this.m_ColumnTimestampType != 92 && this.m_ColumnTimestampType != 93) {
            throw new IllegalStateException("Timestamp column '" + this.m_ColumnTimestamp + "' must be a integer or date-related type: " + this.m_ColumnTimestampType);
        }
        if (this.m_ColumnValueIndex == -1) {
            if (this.m_ColumnValue.isEmpty()) {
                throw new IllegalStateException("No suitable 'value' column found in result set!");
            }
            throw new IllegalStateException("Value column '" + this.m_ColumnValue + "' not found in result set!");
        }
        if (!SQL.isNumeric((int)this.m_ColumnValueType)) {
            throw new IllegalStateException("Value column '" + this.m_ColumnValue + "' must be a numeric type: " + this.m_ColumnValueType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doExecute() {
        String result = null;
        if (this.m_DatabaseConnection == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                return "No database connection available!";
            }
        }
        if (result != null) return result;
        String query = null;
        String id = this.m_InputToken.getPayload().toString();
        ResultSet rs = null;
        try {
            query = this.m_SQL.getValue().replace(PLACEHOLDER_ID, id);
            query = this.getVariables().expand(query);
            rs = SQL.getSingleton((AbstractDatabaseConnection)this.m_DatabaseConnection).getResultSet(query);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("SQL: " + query);
            }
            if (this.m_ColumnTimestampIndex == -1) {
                this.analyzeColumns(rs);
            }
            Timeseries ts = this.read(rs);
            ts.setID(id);
            this.m_OutputToken = new Token((Object)ts);
            if (rs == null) return result;
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to execute statement: " + (query == null ? this.m_SQL : query), e);
                if (rs == null) return result;
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                SQL.closeAll(rs);
                throw throwable;
            }
            SQL.closeAll((ResultSet)rs);
            return result;
        }
        SQL.closeAll((ResultSet)rs);
        return result;
    }
}

