/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.data.timeseries.TimeseriesPoint;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import java.awt.Color;
import java.awt.Graphics;

public class SelectedTimestampPaintlet
extends AbstractTimeseriesPaintlet {
    private static final long serialVersionUID = 4296847364394457330L;
    protected TimeseriesPoint m_Point;
    protected Color m_Color;

    public String globalInfo() {
        return "Paintlet for highlighting a selected timeseries data point on a panel.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    protected void initialize() {
        super.initialize();
        this.m_Point = null;
    }

    public void setPoint(TimeseriesPoint value) {
        if (value != this.m_Point || value != null && !value.equals((Object)this.m_Point)) {
            this.m_Point = value;
            this.memberChanged();
        }
    }

    public TimeseriesPoint getPoint() {
        return this.m_Point;
    }

    public void setColor(Color value) {
        if (value != this.m_Color || value != null && !value.equals(this.m_Color)) {
            this.m_Color = value;
            this.memberChanged();
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the selected timestamp.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.POST_PAINT;
    }

    protected void doPerformPaint(Graphics g, PaintEvent.PaintMoment moment) {
        TimeseriesPoint point = this.getPoint();
        if (point != null) {
            AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            g.setColor(this.getColor());
            g.drawLine(axisX.valueToPos((double)point.getTimestamp().getTime()), 0, axisX.valueToPos((double)point.getTimestamp().getTime()), this.getPanel().getHeight());
            g.drawString(axisX.valueToDisplay((double)point.getTimestamp().getTime()), axisX.valueToPos((double)point.getTimestamp().getTime()) + 10, 10);
        }
    }
}

