/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintletWithMarkers;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import adams.gui.visualization.timeseries.TimeseriesContainer;
import adams.gui.visualization.timeseries.TimeseriesContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Date;
import java.util.List;

public class TimeseriesPaintlet
extends AbstractTimeseriesPaintlet
implements AntiAliasingSupporter,
PaintletWithMarkers {
    private static final long serialVersionUID = -6475036298238205843L;
    protected int m_MarkerExtent;
    protected boolean m_MarkersEnabled;
    protected boolean m_AlwaysShowMarkers;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for painting the timeseries data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("markers-extent", "markerExtent", (Object)GUIHelper.getInteger(((Object)((Object)this)).getClass(), (String)"markersExtent", (Integer)7), (Number)0, null);
        this.m_OptionManager.add("markers-disabled", "markersDisabled", (Object)(GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"markersEnabled", (Boolean)true) == false ? 1 : 0));
        this.m_OptionManager.add("always-show-markers", "alwaysShowMarkers", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"alwaysShowMarkers", (Boolean)true));
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public Color getColor(int index) {
        Color result = Color.BLUE;
        AbstractContainer cont = this.getDataContainerPanel().getContainerManager().get(index);
        if (cont instanceof ColorContainer) {
            result = ((ColorContainer)cont).getColor();
        }
        return result;
    }

    public boolean isMarkersDisabled() {
        return !this.m_MarkersEnabled;
    }

    public void setMarkersDisabled(boolean value) {
        this.m_MarkersEnabled = !value;
        this.memberChanged();
    }

    public String markersDisabledTipText() {
        return "If set to true, the markers are disabled.";
    }

    public boolean getAlwaysShowMarkers() {
        return this.m_AlwaysShowMarkers;
    }

    public void setAlwaysShowMarkers(boolean value) {
        this.m_AlwaysShowMarkers = value;
        this.memberChanged();
    }

    public String alwaysShowMarkersTipText() {
        return "If set to true, the markers are always displayed, not just when zoomed in.";
    }

    public void setMarkerExtent(int value) {
        if (value >= 0) {
            this.m_MarkerExtent = value;
            this.memberChanged();
        } else {
            System.err.println("Marker extent must be >= 0 (provided: " + value + ")!");
        }
    }

    public int getMarkerExtent() {
        return this.m_MarkerExtent;
    }

    public String markerExtentTipText() {
        return "The size of the markers in pixels.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    protected void drawData(Graphics g, Timeseries data, Color color, MarkerShape marker) {
        int end;
        if (data.size() == 0) {
            return;
        }
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        if (this.m_AntiAliasingEnabled) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        int start = TimeseriesUtils.findClosestTimestamp(points, new Date((long)Math.floor(axisX.getMinimum())));
        if (start > 0) {
            --start;
        }
        if ((end = TimeseriesUtils.findClosestTimestamp(points, new Date((long)Math.ceil(axisX.getMaximum())))) < data.size() - 1) {
            ++end;
        }
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        int prevX = axisX.valueToPos((double)((TimeseriesPoint)((Object)points.get(start))).getTimestamp().getTime());
        int prevY = axisY.valueToPos(((TimeseriesPoint)((Object)points.get(start))).getValue());
        int prevMarkerX = 0;
        int prevMarkerY = 0;
        for (int i = start; i <= end; ++i) {
            TimeseriesPoint curr = (TimeseriesPoint)((Object)points.get(i));
            currX = axisX.valueToPos(TimeseriesPoint.toDouble((Long)curr.getTimestamp().getTime()).doubleValue());
            if (i != start && i != end && currX == prevX) continue;
            currY = axisY.valueToPos(TimeseriesPoint.toDouble((Double)curr.getValue()).doubleValue());
            g.drawLine(prevX, prevY, currX, currY);
            if (marker != MarkerShape.NONE && Math.sqrt(Math.pow(currX - prevMarkerX, 2.0) + Math.pow(currY - prevMarkerY, 2.0)) > (double)(this.m_MarkerExtent * 2)) {
                if (marker == MarkerShape.BOX) {
                    g.drawRect(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1);
                } else if (marker == MarkerShape.CIRCLE) {
                    g.drawArc(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1, 0, 360);
                } else if (marker == MarkerShape.TRIANGLE) {
                    int[] x = new int[3];
                    int[] y = new int[3];
                    x[0] = currX - this.m_MarkerExtent / 2;
                    y[0] = currY + this.m_MarkerExtent / 2;
                    x[1] = x[0] + this.m_MarkerExtent;
                    y[1] = y[0];
                    x[2] = currX;
                    y[2] = y[0] - this.m_MarkerExtent;
                    g.drawPolygon(x, y, 3);
                }
                prevMarkerX = currX;
                prevMarkerY = currY;
            }
            prevX = currX;
            prevY = currY;
        }
    }

    protected MarkerShape getMarkerShape(int index) {
        MarkerShape result = MarkerShape.NONE;
        if (this.m_MarkersEnabled && this.m_MarkerExtent > 0 && (this.getPlot().isZoomed() || this.m_AlwaysShowMarkers)) {
            MarkerShape[] shapes = MarkerShape.values();
            result = shapes[index % (shapes.length - 1) + 1];
        }
        return result;
    }

    protected void doPerformPaint(Graphics g, PaintEvent.PaintMoment moment) {
        TimeseriesContainerManager manager = (TimeseriesContainerManager)this.getDataContainerPanel().getContainerManager();
        for (int i = 0; i < manager.count(); ++i) {
            TimeseriesContainer cont = (TimeseriesContainer)manager.get(i);
            if (!cont.isVisible() || manager.isFiltered() && !manager.isFiltered(i)) continue;
            Timeseries data = (Timeseries)((Object)cont.getPayload());
            this.drawData(g, data, this.getColor(i), this.getMarkerShape(i));
        }
    }

    public static enum MarkerShape {
        NONE,
        BOX,
        CIRCLE,
        TRIANGLE;

    }
}

